/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.index.mapper;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.BytesRef;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.opensearch.index.mapper.BinaryFieldMapper;

@Warmup(iterations=1)
@Measurement(iterations=1)
@Fork(value=1)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Thread)
public class CustomBinaryDocValuesFieldBenchmark {
    static final String FIELD_NAME = "dummy";
    static final String SEED_VALUE = "seed";

    @Benchmark
    public void add(BenchmarkParameters parameters, Blackhole blackhole) {
        BinaryFieldMapper.CustomBinaryDocValuesField customBinaryDocValuesField = new BinaryFieldMapper.CustomBinaryDocValuesField(FIELD_NAME, new BytesRef((CharSequence)SEED_VALUE).bytes);
        for (int i = 0; i < parameters.maximumNumberOfEntries; ++i) {
            ThreadLocalRandom.current().nextBytes(parameters.bytes);
            customBinaryDocValuesField.add(parameters.bytes);
        }
    }

    @Benchmark
    public void binaryValue(BenchmarkParameters parameters, Blackhole blackhole) {
        blackhole.consume((Object)parameters.customBinaryDocValuesField.binaryValue());
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkParameters {
        @Param(value={"8", "32", "128", "512"})
        int maximumNumberOfEntries;
        @Param(value={"8", "32", "128", "512"})
        int entrySize;
        BinaryFieldMapper.CustomBinaryDocValuesField customBinaryDocValuesField;
        byte[] bytes;

        @Setup
        public void setup() {
            this.customBinaryDocValuesField = new BinaryFieldMapper.CustomBinaryDocValuesField(CustomBinaryDocValuesFieldBenchmark.FIELD_NAME, new BytesRef((CharSequence)CustomBinaryDocValuesFieldBenchmark.SEED_VALUE).bytes);
            this.bytes = new byte[this.entrySize];
            for (int i = 0; i < this.maximumNumberOfEntries; ++i) {
                ThreadLocalRandom.current().nextBytes(this.bytes);
                this.customBinaryDocValuesField.add(this.bytes);
            }
        }
    }
}

