/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.index.codec.fuzzy;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.opensearch.common.UUIDs;
import org.opensearch.index.codec.fuzzy.FuzzySet;
import org.opensearch.index.codec.fuzzy.FuzzySetFactory;
import org.opensearch.index.codec.fuzzy.FuzzySetParameters;

@Fork(value=3)
@Warmup(iterations=2)
@Measurement(iterations=5, time=60, timeUnit=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class FilterConstructionBenchmark {
    private List<BytesRef> items;
    @Param(value={"1000000", "10000000", "50000000"})
    private int numIds;
    @Param(value={"0.0511", "0.1023", "0.2047"})
    private double fpp;
    private FuzzySetFactory fuzzySetFactory;
    private String fieldName;

    @Setup
    public void setupIds() {
        this.fieldName = "_id";
        this.items = IntStream.range(0, this.numIds).mapToObj(i -> new BytesRef((CharSequence)UUIDs.base64UUID())).collect(Collectors.toList());
        FuzzySetParameters parameters = new FuzzySetParameters(() -> this.fpp);
        this.fuzzySetFactory = new FuzzySetFactory(Map.of(this.fieldName, parameters));
    }

    @Benchmark
    public FuzzySet buildFilter() throws IOException {
        return this.fuzzySetFactory.createFuzzySet(this.items.size(), this.fieldName, () -> this.items.iterator());
    }
}

