/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.benchmark.fs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.opensearch.common.logging.LogConfigurator;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;

@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=3)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
public class AvailableIndexFoldersBenchmark {
    private NodeEnvironment.NodePath nodePath;
    private NodeEnvironment nodeEnv;
    private Set<String> excludedDirs;

    @Setup
    public void setup() throws IOException {
        Path path = Files.createTempDirectory("test", new FileAttribute[0]);
        String[] paths = new String[]{path.toString()};
        this.nodePath = new NodeEnvironment.NodePath(path);
        LogConfigurator.setNodeName((String)"test");
        Settings settings = Settings.builder().put(Environment.PATH_HOME_SETTING.getKey(), path).putList(Environment.PATH_DATA_SETTING.getKey(), paths).build();
        this.nodeEnv = new NodeEnvironment(settings, new Environment(settings, null));
        Files.createDirectories(this.nodePath.indicesPath, new FileAttribute[0]);
        this.excludedDirs = new HashSet<String>();
        int numIndices = 5000;
        for (int i = 0; i < numIndices; ++i) {
            String dirName = "dir" + i;
            Files.createDirectory(this.nodePath.indicesPath.resolve(dirName), new FileAttribute[0]);
            this.excludedDirs.add(dirName);
        }
        if (this.nodeEnv.availableIndexFoldersForPath(this.nodePath).size() != numIndices) {
            throw new IllegalStateException("bad size");
        }
        if (this.nodeEnv.availableIndexFoldersForPath(this.nodePath, this.excludedDirs::contains).size() != 0) {
            throw new IllegalStateException("bad size");
        }
    }

    @Benchmark
    public Set<String> availableIndexFolderNaive() throws IOException {
        return this.nodeEnv.availableIndexFoldersForPath(this.nodePath);
    }

    @Benchmark
    public Set<String> availableIndexFolderOptimized() throws IOException {
        return this.nodeEnv.availableIndexFoldersForPath(this.nodePath, this.excludedDirs::contains);
    }
}

