/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.test.matcher;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class MapEquals
extends TypeSafeMatcher<Map<String, Object>> {
    private final Map<String, Object> expectedMap;
    static final String DEFAULT_TIMESTAMP_KEY_FOR_EVENT = "@timestamp";

    MapEquals(Map<String, Object> map) {
        this.expectedMap = map;
    }

    protected boolean matchesSafely(Map<String, Object> actualMap) {
        HashMap<String, Object> modifiedExpectedMap = new HashMap<String, Object>(this.expectedMap);
        HashMap<String, Object> modifiedActualMap = new HashMap<String, Object>(actualMap);
        modifiedExpectedMap.remove(DEFAULT_TIMESTAMP_KEY_FOR_EVENT);
        modifiedActualMap.remove(DEFAULT_TIMESTAMP_KEY_FOR_EVENT);
        return modifiedExpectedMap.equals(modifiedActualMap);
    }

    public void describeTo(Description description) {
        description.appendText(String.valueOf(this.expectedMap));
    }

    public static MapEquals isEqualWithoutTimestamp(Map<String, Object> expectedMap) {
        return new MapEquals(expectedMap);
    }
}

