/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.test.plugins.junit;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;
import org.opensearch.dataprepper.core.validation.LoggingPluginErrorsHandler;
import org.opensearch.dataprepper.core.validation.PluginErrorCollector;
import org.opensearch.dataprepper.event.TestEventFactory;
import org.opensearch.dataprepper.event.TestEventKeyFactory;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.pipeline.parser.DataPrepperDeserializationProblemHandler;
import org.opensearch.dataprepper.plugin.DefaultPluginFactory;
import org.opensearch.dataprepper.plugin.ExperimentalConfiguration;
import org.opensearch.dataprepper.plugin.ExperimentalConfigurationContainer;
import org.opensearch.dataprepper.plugin.ExtensionsConfiguration;
import org.opensearch.dataprepper.validation.PluginErrorsHandler;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

class TestApplicationContextProvider {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestApplicationContextProvider.class});

    TestApplicationContextProvider() {
    }

    static ApplicationContext get(ExtensionContext extensionContext) {
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        return (ApplicationContext)store.getOrComputeIfAbsent((Object)"applicationContext", key -> TestApplicationContextProvider.createPluginFactory(), ApplicationContext.class);
    }

    private static ApplicationContext createPluginFactory() {
        AnnotationConfigApplicationContext publicContext = new AnnotationConfigApplicationContext();
        publicContext.registerBean(EventFactory.class, TestEventFactory::getTestEventFactory, new BeanDefinitionCustomizer[0]);
        publicContext.registerBean(EventKeyFactory.class, TestEventKeyFactory::getTestEventFactory, new BeanDefinitionCustomizer[0]);
        publicContext.scan(new String[]{"org.opensearch.dataprepper.expression"});
        publicContext.refresh();
        AnnotationConfigApplicationContext coreContext = new AnnotationConfigApplicationContext();
        coreContext.setParent((ApplicationContext)publicContext);
        ExperimentalConfigurationContainer experimentalConfigurationContainer = (ExperimentalConfigurationContainer)Mockito.mock(ExperimentalConfigurationContainer.class);
        ExperimentalConfiguration experimentalConfiguration = (ExperimentalConfiguration)Mockito.mock(ExperimentalConfiguration.class);
        Mockito.when((Object)experimentalConfigurationContainer.getExperimental()).thenReturn((Object)experimentalConfiguration);
        coreContext.scan(new String[]{DefaultPluginFactory.class.getPackage().getName()});
        coreContext.registerBean(DataPrepperDeserializationProblemHandler.class, DataPrepperDeserializationProblemHandler::new, new BeanDefinitionCustomizer[0]);
        coreContext.registerBean(PluginErrorCollector.class, PluginErrorCollector::new, new BeanDefinitionCustomizer[0]);
        coreContext.registerBean(PluginErrorsHandler.class, LoggingPluginErrorsHandler::new, new BeanDefinitionCustomizer[0]);
        coreContext.registerBean(ExtensionsConfiguration.class, () -> (ExtensionsConfiguration)Mockito.mock(ExtensionsConfiguration.class), new BeanDefinitionCustomizer[0]);
        coreContext.registerBean(PipelinesDataFlowModel.class, () -> (PipelinesDataFlowModel)Mockito.mock(PipelinesDataFlowModel.class), new BeanDefinitionCustomizer[0]);
        coreContext.registerBean(AcknowledgementSetManager.class, () -> (AcknowledgementSetManager)Mockito.mock(AcknowledgementSetManager.class), new BeanDefinitionCustomizer[0]);
        coreContext.registerBean(ExperimentalConfigurationContainer.class, () -> experimentalConfigurationContainer, new BeanDefinitionCustomizer[0]);
        coreContext.refresh();
        return coreContext;
    }
}

