/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.write_json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.micrometer.core.instrument.Counter;
import java.util.Collection;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.write_json.WriteJsonProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="write_json", pluginType=Processor.class, pluginConfigurationType=WriteJsonProcessorConfig.class)
public class WriteJsonProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteJsonProcessor.class);
    private static final String WRITE_JSON_FAILED_COUNTER = "writeJsonFailedCounter";
    private final String source;
    private final Counter writeJsonFailedCounter;
    private String target;
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    @DataPrepperPluginConstructor
    public WriteJsonProcessor(WriteJsonProcessorConfig writeJsonProcessorConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory) {
        super(pluginMetrics);
        this.source = writeJsonProcessorConfig.getSource();
        this.target = writeJsonProcessorConfig.getTarget();
        if (this.target == null) {
            this.target = this.source;
        }
        this.writeJsonFailedCounter = pluginMetrics.counter(WRITE_JSON_FAILED_COUNTER);
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event event = (Event)record.getData();
            Object value = event.get(this.source, Object.class);
            if (value == null) continue;
            try {
                event.put(this.target, (Object)this.objectMapper.writeValueAsString(value));
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "Failed to convert source to json string", (Throwable)e);
                this.writeJsonFailedCounter.increment();
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

