/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.truncate;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>truncate</code> processor truncates a key's value at the beginning, the end, or on both sides of the value string, based on the processor\u2019s configuration.")
public class TruncateProcessorConfig {
    @NotEmpty
    @NotNull
    @JsonPropertyDescription(value="A list of entries to add to an event.")
    private @NotEmpty @NotNull List<@Valid Entry> entries;

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        @JsonProperty(value="source_keys")
        @JsonPropertyDescription(value="The list of source keys that will be modified by the processor. The default value is an empty list, which indicates that all values will be truncated.")
        private List<String> sourceKeys;
        @JsonProperty(value="start_at", defaultValue="0")
        @JsonPropertyDescription(value="The index into the string value to start truncation. Default is <code>0</code>, which specifies to start truncation at the beginning of each key's value.")
        private Integer startAt;
        @JsonProperty(value="length")
        @JsonPropertyDescription(value="The length of the string after truncation. When not specified, the processor will measure the length based on where the string ends.")
        private Integer length;
        @JsonProperty(value="recursive")
        @JsonPropertyDescription(value="Recursively truncates the fields. If the value of a field is a map, then it recursively applies truncate operation on the fields in the map.")
        private Boolean recurse = false;
        @JsonProperty(value="truncate_when")
        @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>. If specified, the <code>truncate</code> processor will only run on events when the expression evaluates to true.")
        @ExampleValues(value={@ExampleValues.Example(value="length(/node_name) > 10", description="Truncate if the value of node_name is greater than 10 characters.")})
        private String truncateWhen;

        public Entry(List<String> sourceKeys, Integer startAt, Integer length, String truncateWhen, Boolean recurse) {
            this.sourceKeys = sourceKeys;
            this.startAt = startAt;
            this.length = length;
            this.truncateWhen = truncateWhen;
            this.recurse = recurse;
        }

        public Entry() {
        }

        public List<String> getSourceKeys() {
            return this.sourceKeys;
        }

        public Integer getStartAt() {
            return this.startAt;
        }

        public Boolean getRecurse() {
            return this.recurse;
        }

        public Integer getLength() {
            return this.length;
        }

        public String getTruncateWhen() {
            return this.truncateWhen;
        }

        @AssertTrue(message="At least one of start_at or length or both must be specified and the values must be positive integers")
        public @AssertTrue(message="At least one of start_at or length or both must be specified and the values must be positive integers") boolean isValidConfig() {
            if (this.length == null && this.startAt == null) {
                return false;
            }
            if (this.length != null && this.length < 0) {
                return false;
            }
            return this.startAt == null || this.startAt >= 0;
        }
    }
}

