/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.truncate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.truncate.TruncateProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="truncate", pluginType=Processor.class, pluginConfigurationType=TruncateProcessorConfig.class)
public class TruncateProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(TruncateProcessor.class);
    private final ExpressionEvaluator expressionEvaluator;
    private final List<TruncateProcessorConfig.Entry> entries;

    @DataPrepperPluginConstructor
    public TruncateProcessor(PluginMetrics pluginMetrics, TruncateProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.expressionEvaluator = expressionEvaluator;
        this.entries = config.getEntries();
        config.getEntries().forEach(entry -> {
            if (entry.getTruncateWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getTruncateWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("truncate_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getTruncateWhen()));
            }
        });
    }

    private String getTruncatedValue(String value, int startIndex, Integer length) {
        String truncatedValue = length == null || startIndex + length >= value.length() ? value.substring(startIndex) : value.substring(startIndex, startIndex + length);
        return truncatedValue;
    }

    private void truncateKey(Event event, String key, Object value, TruncateProcessorConfig.Entry entryConfig) {
        boolean recurse = entryConfig.getRecurse();
        int startIndex = entryConfig.getStartAt() == null ? 0 : entryConfig.getStartAt();
        Integer length = entryConfig.getLength();
        if (value instanceof String) {
            event.put(key, (Object)this.getTruncatedValue((String)value, startIndex, length));
        } else if (value instanceof List) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object listItem : (List)value) {
                if (listItem instanceof String) {
                    result.add(this.getTruncatedValue((String)listItem, startIndex, length));
                    continue;
                }
                result.add((String)listItem);
            }
            event.put(key, result);
        } else if (recurse && value instanceof Map) {
            Map valueMap = (Map)value;
            for (Map.Entry mapEntry : valueMap.entrySet()) {
                this.truncateKey(event, key + "/" + (String)mapEntry.getKey(), mapEntry.getValue(), entryConfig);
            }
        }
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                for (TruncateProcessorConfig.Entry entry : this.entries) {
                    List<String> sourceKeys = entry.getSourceKeys();
                    String truncateWhen = entry.getTruncateWhen();
                    boolean recurse = entry.getRecurse();
                    int startIndex = entry.getStartAt() == null ? 0 : entry.getStartAt();
                    Integer length = entry.getLength();
                    if (truncateWhen != null && !this.expressionEvaluator.evaluateConditional(truncateWhen, recordEvent).booleanValue()) continue;
                    if (sourceKeys == null) {
                        for (Map.Entry entry2 : recordEvent.toMap().entrySet()) {
                            this.truncateKey(recordEvent, (String)entry2.getKey(), entry2.getValue(), entry);
                        }
                        continue;
                    }
                    for (String string : sourceKeys) {
                        if (!recordEvent.containsKey(string)) continue;
                        Object value = recordEvent.get(string, Object.class);
                        this.truncateKey(recordEvent, string, value, entry);
                    }
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

