/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

class KeyInfo {
    private final String keyStr;
    private final EventKey staticKey;
    private final boolean isDynamic;
    private final String[] parsedComponents;
    private final EventKeyFactory factory;

    KeyInfo(String keyStr, EventKeyFactory factory) {
        this.keyStr = keyStr;
        this.factory = factory;
        this.isDynamic = keyStr != null && (keyStr.contains("%{") || keyStr.contains("${"));
        this.staticKey = !this.isDynamic && keyStr != null ? factory.createEventKey(keyStr) : null;
        this.parsedComponents = keyStr != null ? keyStr.split("/") : new String[]{};
    }

    EventKey resolveKey(Event event, ExpressionEvaluator evaluator) {
        if (!this.isDynamic) {
            return this.staticKey;
        }
        try {
            String resolvedKey = event.formatString(this.keyStr, evaluator);
            return this.factory.createEventKey(resolvedKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean isDynamic() {
        return this.isDynamic;
    }

    EventKey getStaticKey() {
        return this.staticKey;
    }

    String getKeyStr() {
        return this.keyStr;
    }

    String[] getParsedComponents() {
        return this.parsedComponents;
    }
}

