/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.math.NumberUtils;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.translate.CachingKeyResolver;
import org.opensearch.dataprepper.plugins.processor.translate.JsonExtractor;
import org.opensearch.dataprepper.plugins.processor.translate.KeyResolver;
import org.opensearch.dataprepper.plugins.processor.translate.MappingsParameterConfig;
import org.opensearch.dataprepper.plugins.processor.translate.TargetsParameterConfig;
import org.opensearch.dataprepper.plugins.processor.translate.TranslateProcessorConfig;
import org.opensearch.dataprepper.typeconverter.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="translate", pluginType=Processor.class, pluginConfigurationType=TranslateProcessorConfig.class)
public class TranslateProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(TranslateProcessor.class);
    private final ExpressionEvaluator expressionEvaluator;
    private final List<MappingsParameterConfig> mappingsConfig;
    private final JacksonEvent.Builder eventBuilder = JacksonEvent.builder();
    private final JsonExtractor jsonExtractor = new JsonExtractor();
    private final KeyResolver keyResolver;

    @DataPrepperPluginConstructor
    public TranslateProcessor(PluginMetrics pluginMetrics, TranslateProcessorConfig translateProcessorConfig, ExpressionEvaluator expressionEvaluator, EventKeyFactory eventKeyFactory) {
        super(pluginMetrics);
        this.expressionEvaluator = expressionEvaluator;
        this.mappingsConfig = translateProcessorConfig.getCombinedMappingsConfigs();
        this.keyResolver = new CachingKeyResolver(eventKeyFactory);
        Optional.ofNullable(this.mappingsConfig).ifPresent(configs -> configs.forEach(MappingsParameterConfig::parseMappings));
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        if (Objects.isNull(this.mappingsConfig)) {
            return records;
        }
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            for (MappingsParameterConfig mappingConfig : this.mappingsConfig) {
                try {
                    List<TargetsParameterConfig> targetsConfig = mappingConfig.getTargetsParameterConfigs();
                    for (TargetsParameterConfig targetConfig : targetsConfig) {
                        Object sourceObject = mappingConfig.getSource();
                        this.translateSource(sourceObject, recordEvent, targetConfig);
                    }
                }
                catch (Exception ex) {
                    LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("Error mapping the source [{}] of entry [{}]").addArgument(mappingConfig.getSource()).addArgument(record.getData()).setCause((Throwable)ex).log();
                }
            }
        }
        return records;
    }

    private List<String> getSourceKeys(Object sourceObject) {
        List<Object> sourceKeys;
        if (sourceObject instanceof List) {
            sourceKeys = (ArrayList)sourceObject;
        } else if (sourceObject instanceof String) {
            sourceKeys = List.of((String)sourceObject);
        } else {
            String exceptionMsg = "source option configured incorrectly. source can only be a String or list of Strings";
            throw new InvalidPluginConfigurationException(exceptionMsg);
        }
        return sourceKeys;
    }

    private void translateSource(Object sourceObject, Event recordEvent, TargetsParameterConfig targetConfig) {
        List<String> sourceKeysPaths = this.getSourceKeys(sourceObject);
        if (sourceKeysPaths.isEmpty()) {
            return;
        }
        ArrayList<String> sourceKeys = new ArrayList<String>();
        for (String sourceKeyPath : sourceKeysPaths) {
            sourceKeys.add(this.jsonExtractor.getLeafField(sourceKeyPath));
        }
        String commonPath = this.jsonExtractor.getParentPath(sourceKeysPaths.get(0));
        if (commonPath.isEmpty()) {
            this.performMappings(recordEvent, sourceKeys, sourceObject, targetConfig);
            return;
        }
        String rootField = this.jsonExtractor.getRootField(commonPath);
        EventKey rootKey = this.keyResolver.resolveKey(rootField, recordEvent, this.expressionEvaluator);
        if (rootKey == null || !recordEvent.containsKey(rootKey)) {
            return;
        }
        Map recordObject = recordEvent.toMap();
        List<Object> targetObjects = this.jsonExtractor.getObjectFromPath(commonPath, recordObject);
        if (!targetObjects.isEmpty()) {
            targetObjects.forEach(targetObj -> this.performMappings(targetObj, sourceKeys, sourceObject, targetConfig));
            recordEvent.put(rootKey, recordObject.get(rootField));
        }
    }

    private String getSourceValue(Object recordObject, String sourceKey) {
        Event event;
        EventKey key;
        Optional<Object> sourceValue = recordObject instanceof Map ? Optional.ofNullable(((Map)recordObject).get(sourceKey)) : ((key = this.keyResolver.resolveKey(sourceKey, event = (Event)recordObject, this.expressionEvaluator)) != null ? Optional.ofNullable(event.get(key, String.class)) : Optional.empty());
        return sourceValue.map(Object::toString).orElse(null);
    }

    private Object getTargetValue(Object sourceObject, List<Object> targetValues, TargetsParameterConfig targetConfig) {
        TypeConverter converter = targetConfig.getTargetType().getTargetConverter();
        if (sourceObject instanceof String) {
            return converter.convert(targetValues.get(0));
        }
        return targetValues.stream().map(arg_0 -> ((TypeConverter)converter).convert(arg_0)).collect(Collectors.toList());
    }

    private void performMappings(Object recordObject, List<String> sourceKeys, Object sourceObject, TargetsParameterConfig targetConfig) {
        if (Objects.isNull(recordObject) || Objects.isNull(sourceObject) || Objects.isNull(targetConfig) || sourceKeys.isEmpty()) {
            return;
        }
        String translateWhen = targetConfig.getTranslateWhen();
        if (!this.isExpressionValid(translateWhen, recordObject)) {
            return;
        }
        ArrayList<Object> targetValues = new ArrayList<Object>();
        for (String sourceKey : sourceKeys) {
            String sourceValue = this.getSourceValue(recordObject, sourceKey);
            if (sourceValue == null) continue;
            Optional<Object> targetValue = this.getTargetValueForSource(sourceValue, targetConfig);
            targetValue.ifPresent(targetValues::add);
        }
        this.addTargetToRecords(sourceObject, targetValues, recordObject, targetConfig);
    }

    private boolean isExpressionValid(String translateWhen, Object recordObject) {
        Object recordEvent = recordObject instanceof Map ? this.eventBuilder.withData(recordObject).withEventType("event").build() : (Event)recordObject;
        return translateWhen == null || this.expressionEvaluator.evaluateConditional(translateWhen, recordEvent) != false;
    }

    private Optional<Object> getTargetValueForSource(String sourceValue, TargetsParameterConfig targetConfig) {
        Optional<Object> targetValue = Optional.empty();
        targetValue = targetValue.or(() -> this.matchesIndividualEntry(sourceValue, targetConfig)).or(() -> this.matchesRangeEntry(sourceValue, targetConfig)).or(() -> this.matchesPatternEntry(sourceValue, targetConfig)).or(() -> Optional.ofNullable(targetConfig.getDefaultValue()));
        return targetValue;
    }

    private Optional<Object> matchesIndividualEntry(String sourceValue, TargetsParameterConfig targetConfig) {
        Map<String, Object> individualMappings = targetConfig.fetchIndividualMappings();
        if (individualMappings.containsKey(sourceValue)) {
            return Optional.of(individualMappings.get(sourceValue));
        }
        return Optional.empty();
    }

    private Optional<Object> matchesRangeEntry(String sourceValue, TargetsParameterConfig targetConfig) {
        if (!NumberUtils.isParsable((String)sourceValue)) {
            return Optional.empty();
        }
        Float floatKey = Float.valueOf(Float.parseFloat(sourceValue));
        LinkedHashMap<Range<Float>, Object> rangeMappings = targetConfig.fetchRangeMappings();
        for (Map.Entry<Range<Float>, Object> rangeEntry : rangeMappings.entrySet()) {
            Range<Float> range = rangeEntry.getKey();
            if (!range.contains((Object)floatKey)) continue;
            return Optional.of(rangeEntry.getValue());
        }
        return Optional.empty();
    }

    private Optional<Object> matchesPatternEntry(String sourceValue, TargetsParameterConfig targetConfig) {
        Map<Pattern, Object> compiledPatterns = targetConfig.fetchCompiledPatterns();
        if (compiledPatterns.isEmpty()) {
            return Optional.empty();
        }
        boolean exact = targetConfig.getRegexParameterConfiguration().getExact();
        for (Pattern pattern : compiledPatterns.keySet()) {
            Matcher matcher = pattern.matcher(sourceValue);
            if (matcher.matches()) {
                return Optional.of(compiledPatterns.get(pattern));
            }
            if (exact || !matcher.find()) continue;
            String targetValue = (String)compiledPatterns.get(pattern);
            return Optional.of(matcher.replaceAll(targetValue));
        }
        return Optional.empty();
    }

    private void addTargetToRecords(Object sourceObject, List<Object> targetValues, Object recordObject, TargetsParameterConfig targetMappings) {
        Event event;
        EventKey targetKey;
        if (targetValues.isEmpty()) {
            return;
        }
        String targetField = targetMappings.getTarget();
        if (recordObject instanceof Map) {
            Map recordMap = (Map)recordObject;
            recordMap.put(targetField, this.getTargetValue(sourceObject, targetValues, targetMappings));
        } else if (recordObject instanceof Event && (targetKey = this.keyResolver.resolveKey(targetField, event = (Event)recordObject, this.expressionEvaluator)) != null) {
            event.put(targetKey, this.getTargetValue(sourceObject, targetValues, targetMappings));
        }
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

