/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.Range;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.plugins.processor.mutateevent.TargetType;
import org.opensearch.dataprepper.plugins.processor.translate.MappingsParser;
import org.opensearch.dataprepper.plugins.processor.translate.RegexParameterConfiguration;
import org.opensearch.dataprepper.typeconverter.TypeConverter;

public class TargetsParameterConfig {
    static final String MAP_KEY = "map";
    static final String REGEX_KEY = "regex";
    private final TypeConverter converter;
    private final LinkedHashMap<Range<Float>, Object> rangeMappings = new LinkedHashMap();
    private final Map<String, Object> individualMappings = new HashMap<String, Object>();
    private final Map<Pattern, Object> compiledPatterns = new HashMap<Pattern, Object>();
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="The key that specifies the field in the output in which the translated value will be placed.")
    @NotNull
    @NotEmpty
    private String target;
    @JsonProperty(value="map")
    @JsonPropertyDescription(value="A list of key-value pairs that define the translations. Each key represents a possible value in the source field, and the corresponding value represents what it should be translated to. At least one of <code>map</code> and <code>regex</code> should be configured.")
    @AlsoRequired(values={@AlsoRequired.Required(name="regex")})
    private Map<String, Object> map;
    @JsonProperty(value="translate_when")
    @JsonPropertyDescription(value="Uses a <a href=\"{{site.url}}{{site.baseurl}}/data-prepper/pipelines/expression-syntax/\">conditional expression</a> to specify a condition for performing the translation. When specified, the expression will only translate when the condition is met.")
    private String translateWhen;
    @JsonProperty(value="regex")
    @JsonPropertyDescription(value="A map of keys that defines the translation map. At least one of <code>map</code> and <code>regex</code> should be configured.")
    @AlsoRequired(values={@AlsoRequired.Required(name="map")})
    private RegexParameterConfiguration regexParameterConfig;
    @JsonProperty(value="default")
    @JsonPropertyDescription(value="The default value to use when no match is found during translation.")
    private String defaultValue;
    @JsonProperty(value="type", defaultValue="string")
    @JsonPropertyDescription(value="Specifies the data type for the target value.")
    private TargetType targetType = TargetType.STRING;

    public TargetsParameterConfig() {
        this.converter = TargetType.STRING.getTargetConverter();
    }

    public TargetsParameterConfig(Map<String, Object> map, String target, RegexParameterConfiguration regexParameterConfig, String translateWhen, String defaultValue, TargetType targetType) {
        this.targetType = Optional.ofNullable(targetType).orElse(TargetType.STRING);
        this.target = target;
        this.map = map;
        this.defaultValue = defaultValue;
        this.regexParameterConfig = regexParameterConfig;
        this.converter = this.targetType.getTargetConverter();
        this.translateWhen = translateWhen;
        this.parseMappings();
    }

    public String getTarget() {
        return this.target;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getTranslateWhen() {
        return this.translateWhen;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public RegexParameterConfiguration getRegexParameterConfiguration() {
        return this.regexParameterConfig;
    }

    public Map<String, Object> fetchIndividualMappings() {
        return this.individualMappings;
    }

    public LinkedHashMap<Range<Float>, Object> fetchRangeMappings() {
        return this.rangeMappings;
    }

    public Map<Pattern, Object> fetchCompiledPatterns() {
        return this.compiledPatterns;
    }

    public TypeConverter getConverter() {
        return this.converter;
    }

    @AssertTrue(message="pattern option is mandatory while configuring regex option")
    public @AssertTrue(message="pattern option is mandatory while configuring regex option") boolean isPatternPresent() {
        return this.regexParameterConfig == null || this.regexParameterConfig.getPatterns() != null;
    }

    @AssertTrue(message="Either map or patterns option needs to be configured under targets.")
    public @AssertTrue(message="Either map or patterns option needs to be configured under targets.") boolean hasMappings() {
        return Stream.of(this.map, this.regexParameterConfig).filter(n -> n != null).count() != 0L;
    }

    @AssertTrue(message="The mapped values do not match the target type provided")
    public @AssertTrue(message="The mapped values do not match the target type provided") boolean isMapTypeValid() {
        if (Objects.isNull(this.map)) {
            return true;
        }
        return this.map.keySet().stream().allMatch(key -> this.checkTargetValueType(this.map.get(key)));
    }

    @AssertTrue(message="The pattern values do not match the target type provided")
    public @AssertTrue(message="The pattern values do not match the target type provided") boolean isPatternTypeValid() {
        if (Objects.isNull(this.regexParameterConfig) || Objects.isNull(this.regexParameterConfig.getPatterns())) {
            return true;
        }
        Map<String, Object> patterns = this.regexParameterConfig.getPatterns();
        return patterns.keySet().stream().allMatch(key -> this.checkTargetValueType(patterns.get(key)));
    }

    private boolean checkTargetValueType(Object val) throws NumberFormatException {
        if (Objects.isNull(this.targetType)) {
            return true;
        }
        try {
            TypeConverter converter = this.targetType.getTargetConverter();
            converter.convert(val);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public void parseMappings() {
        MappingsParser parser = new MappingsParser(this);
        this.individualMappings.putAll(parser.fetchIndividualMappings());
        this.rangeMappings.putAll(parser.fetchRangeMappings());
        this.compiledPatterns.putAll(parser.fetchCompiledPatterns());
    }
}

