/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugins.processor.translate.RegexParameterConfiguration;
import org.opensearch.dataprepper.plugins.processor.translate.TargetsParameterConfig;

public class MappingsParser {
    private final LinkedHashMap<Range<Float>, Object> rangeMappings = new LinkedHashMap();
    private final Map<String, Object> individualMappings = new HashMap<String, Object>();
    private final Map<Pattern, Object> compiledPatterns = new HashMap<Pattern, Object>();

    public MappingsParser(TargetsParameterConfig targetConfig) {
        RegexParameterConfiguration regexConfig = targetConfig.getRegexParameterConfiguration();
        if (Objects.nonNull(regexConfig)) {
            this.compilePatterns(regexConfig.getPatterns());
        }
        this.processMapField(targetConfig.getMap());
        this.checkOverlappingKeys();
    }

    public Map<String, Object> fetchIndividualMappings() {
        return this.individualMappings;
    }

    public LinkedHashMap<Range<Float>, Object> fetchRangeMappings() {
        return this.rangeMappings;
    }

    public Map<Pattern, Object> fetchCompiledPatterns() {
        return this.compiledPatterns;
    }

    private void compilePatterns(Map<String, Object> mappings) {
        for (String pattern : mappings.keySet()) {
            Pattern compiledPattern = Pattern.compile(pattern);
            this.compiledPatterns.put(compiledPattern, mappings.get(pattern));
        }
    }

    private void processMapField(Map<String, Object> map) {
        if (Objects.nonNull(map)) {
            for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
                this.parseIndividualKeys(mapEntry);
            }
        }
    }

    private void parseIndividualKeys(Map.Entry<String, Object> mapEntry) {
        String[] commaSeparatedKeys;
        for (String individualKey : commaSeparatedKeys = mapEntry.getKey().split(",")) {
            if (individualKey.contains("-")) {
                this.addRangeMapping(Map.entry(individualKey, mapEntry.getValue()));
                continue;
            }
            this.addIndividualMapping(individualKey, mapEntry.getValue());
        }
    }

    private void addRangeMapping(Map.Entry<String, Object> mapEntry) {
        String[] rangeKeys = mapEntry.getKey().split("-");
        if (rangeKeys.length != 2 || !StringUtils.isNumericSpace((CharSequence)rangeKeys[0]) || !StringUtils.isNumericSpace((CharSequence)rangeKeys[1])) {
            this.addIndividualMapping(mapEntry.getKey(), mapEntry.getValue());
        } else {
            Float highKey;
            Float lowKey = Float.valueOf(Float.parseFloat(rangeKeys[0]));
            Range rangeEntry = Range.between((Comparable)lowKey, (Comparable)(highKey = Float.valueOf(Float.parseFloat(rangeKeys[1]))));
            if (this.isRangeOverlapping((Range<Float>)rangeEntry)) {
                String exceptionMsg = "map option contains key " + mapEntry.getKey() + " that overlaps with other range entries";
                throw new InvalidPluginConfigurationException(exceptionMsg);
            }
            this.rangeMappings.put((Range<Float>)Range.between((Comparable)lowKey, (Comparable)highKey), mapEntry.getValue());
        }
    }

    private void addIndividualMapping(String key, Object value) {
        if (this.individualMappings.containsKey(key)) {
            String exceptionMsg = "map option contains duplicate entries of " + key;
            throw new InvalidPluginConfigurationException(exceptionMsg);
        }
        this.individualMappings.put(key.strip(), value);
    }

    private boolean isRangeOverlapping(Range<Float> rangeEntry) {
        return this.rangeMappings.keySet().stream().anyMatch(range -> range.isOverlappedBy(rangeEntry));
    }

    private void checkOverlappingKeys() {
        for (String individualKey : this.individualMappings.keySet()) {
            Float floatKey;
            Range range;
            if (!NumberUtils.isParsable((String)individualKey) || !this.isRangeOverlapping((Range<Float>)(range = Range.between((Comparable)(floatKey = Float.valueOf(Float.parseFloat(individualKey))), (Comparable)floatKey)))) continue;
            String exceptionMsg = "map option contains key " + individualKey + " that overlaps with other range entries";
            throw new InvalidPluginConfigurationException(exceptionMsg);
        }
    }
}

