/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.splitevent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.DefaultEventHandle;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.splitevent.SplitEventProcessorConfig;

@DataPrepperPlugin(name="split_event", pluginType=Processor.class, pluginConfigurationType=SplitEventProcessorConfig.class)
public class SplitEventProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    final String delimiter;
    final String delimiterRegex;
    final String field;
    final Pattern pattern;
    private final Function<String, String[]> splitter;

    @DataPrepperPluginConstructor
    public SplitEventProcessor(PluginMetrics pluginMetrics, SplitEventProcessorConfig config) {
        super(pluginMetrics);
        this.delimiter = config.getDelimiter();
        this.delimiterRegex = config.getDelimiterRegex();
        this.field = config.getField();
        if (this.delimiterRegex != null && !this.delimiterRegex.isEmpty() && this.delimiter != null && !this.delimiter.isEmpty()) {
            throw new IllegalArgumentException("delimiter and delimiter_regex cannot be defined at the same time");
        }
        if ((this.delimiterRegex == null || this.delimiterRegex.isEmpty()) && (this.delimiter == null || this.delimiter.isEmpty())) {
            throw new IllegalArgumentException("delimiter or delimiter_regex needs to be defined");
        }
        if (this.delimiterRegex != null && !this.delimiterRegex.isEmpty()) {
            this.pattern = Pattern.compile(this.delimiterRegex);
            this.splitter = this.pattern::split;
        } else {
            this.splitter = inputString -> inputString.split(this.delimiter);
            this.pattern = null;
        }
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        ArrayList<Record<Event>> newRecords = new ArrayList<Record<Event>>();
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            if (!recordEvent.containsKey(this.field)) {
                newRecords.add(record);
                continue;
            }
            Object value = recordEvent.get(this.field, Object.class);
            String[] splitValues = this.splitter.apply((String)value);
            if (splitValues.length <= 1) {
                newRecords.add(record);
                continue;
            }
            for (int i = 0; i < splitValues.length - 1; ++i) {
                Record newRecord = this.createNewRecordFromEvent(recordEvent, splitValues[i]);
                this.addToAcknowledgementSetFromOriginEvent((Event)newRecord.getData(), recordEvent);
                newRecords.add((Record<Event>)newRecord);
            }
            recordEvent.put(this.field, (Object)splitValues[splitValues.length - 1]);
            newRecords.add(record);
        }
        return newRecords;
    }

    protected Record createNewRecordFromEvent(Event recordEvent, String splitValue) {
        JacksonEvent newRecordEvent = JacksonEvent.fromEvent((Event)recordEvent);
        newRecordEvent.put(this.field, (Object)splitValue);
        Record newRecord = new Record((Object)newRecordEvent);
        return newRecord;
    }

    protected void addToAcknowledgementSetFromOriginEvent(Event recordEvent, Event originRecordEvent) {
        DefaultEventHandle eventHandle = (DefaultEventHandle)originRecordEvent.getEventHandle();
        if (eventHandle != null) {
            eventHandle.addEventHandle(recordEvent.getEventHandle());
        }
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

