/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.arns.Arn;

public class StsArnRole {
    private final String accountId;

    private StsArnRole(String roleArn) {
        Arn arnObj = Arn.fromString((String)roleArn);
        Optional accountId = arnObj.accountId();
        if (accountId.isPresent() && ((String)accountId.get()).length() != 12) {
            throw new IllegalArgumentException("ARN has accountId of invalid length.");
        }
        if (!((String)accountId.get()).chars().allMatch(Character::isDigit)) {
            throw new IllegalArgumentException("ARN has accountId with invalid characters.");
        }
        this.accountId = (String)accountId.get();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public static StsArnRole parse(String roleArn) {
        Objects.requireNonNull(roleArn);
        return new StsArnRole(roleArn);
    }
}

