/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import io.micrometer.core.instrument.Counter;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;

public class S3ObjectDeleteWorker {
    private static final Logger LOG = LoggerFactory.getLogger(S3ObjectDeleteWorker.class);
    static final String S3_OBJECTS_DELETED_METRIC_NAME = "s3ObjectsDeleted";
    static final String S3_OBJECTS_DELETE_FAILED_METRIC_NAME = "s3ObjectsDeleteFailed";
    private final S3Client s3Client;
    private final Counter s3ObjectsDeletedCounter;
    private final Counter s3ObjectsDeleteFailedCounter;

    public S3ObjectDeleteWorker(S3Client s3Client, PluginMetrics pluginMetrics) {
        this.s3Client = s3Client;
        this.s3ObjectsDeletedCounter = pluginMetrics.counter(S3_OBJECTS_DELETED_METRIC_NAME);
        this.s3ObjectsDeleteFailedCounter = pluginMetrics.counter(S3_OBJECTS_DELETE_FAILED_METRIC_NAME);
    }

    public void deleteS3Object(DeleteObjectRequest deleteObjectRequest) {
        try {
            DeleteObjectResponse deleteObjectResponse = this.s3Client.deleteObject(deleteObjectRequest);
            if (deleteObjectResponse.sdkHttpResponse().isSuccessful()) {
                LOG.info("Deleted object: {} in S3 bucket: {}. ", (Object)deleteObjectRequest.key(), (Object)deleteObjectRequest.bucket());
                this.s3ObjectsDeletedCounter.increment();
            } else {
                this.s3ObjectsDeleteFailedCounter.increment();
            }
        }
        catch (SdkException e) {
            LOG.error("Failed to delete object: {} from S3 bucket: {}. ", new Object[]{deleteObjectRequest.key(), deleteObjectRequest.bucket(), e});
            this.s3ObjectsDeleteFailedCounter.increment();
        }
    }

    public DeleteObjectRequest buildDeleteObjectRequest(String bucketName, String key) {
        return (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucketName).key(key).build();
    }
}

