/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.opensearch.dataprepper.plugins.source.s3.configuration.FolderPartitioningOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanBucketOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanSchedulingOptions;

public class S3ScanScanOptions {
    @JsonProperty(value="acknowledgment_timeout")
    private Duration acknowledgmentTimeout = Duration.ofHours(2L);
    @JsonProperty(value="folder_partitions")
    @Valid
    private FolderPartitioningOptions folderPartitioningOptions;
    @JsonProperty(value="range")
    private Duration range;
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @JsonProperty(value="start_time")
    private LocalDateTime startTime;
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @JsonProperty(value="end_time")
    private LocalDateTime endTime;
    @JsonProperty(value="buckets")
    @Valid
    private List<S3ScanBucketOptions> buckets;
    @JsonProperty(value="scheduling")
    @Valid
    private S3ScanSchedulingOptions schedulingOptions;

    @AssertTrue(message="At most two options from start_time, end_time and range can be specified at the same time")
    public @AssertTrue(message="At most two options from start_time, end_time and range can be specified at the same time") boolean hasValidTimeOptions() {
        return Stream.of(this.startTime, this.endTime, this.range).filter(x$0 -> Objects.nonNull(x$0)).count() < 3L;
    }

    @AssertFalse(message="start_time or end_time cannot be used along with range")
    public @AssertFalse(message="start_time or end_time cannot be used along with range") boolean hasValidTimeAndRangeOptions() {
        return (this.startTime != null || this.endTime != null) && this.range != null;
    }

    @AssertTrue(message="end_time is not a valid option when using scheduling with s3 scan. One of start_time or range must be used for scheduled scan.")
    public @AssertTrue(message="end_time is not a valid option when using scheduling with s3 scan. One of start_time or range must be used for scheduled scan.") boolean hasValidTimeOptionsWithScheduling() {
        return this.schedulingOptions == null || (this.startTime == null || this.range == null) && this.endTime == null;
    }

    public Duration getRange() {
        return this.range;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public List<S3ScanBucketOptions> getBuckets() {
        return this.buckets;
    }

    public S3ScanSchedulingOptions getSchedulingOptions() {
        return this.schedulingOptions;
    }

    public FolderPartitioningOptions getPartitioningOptions() {
        return this.folderPartitioningOptions;
    }

    public Duration getAcknowledgmentTimeout() {
        return this.acknowledgmentTimeout;
    }
}

