/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataType;

public class PgArrayParser {
    public static Object parseTypedArray(String arrayString, PostgresDataType elementType, ValueParser valueParser) {
        char delimiter = PgArrayParser.getDelimiterForType(elementType);
        List<Object> parsed = PgArrayParser.parseRawArray(arrayString, delimiter);
        if (parsed instanceof List) {
            List<Object> parsedList = parsed;
            List answer = parsedList.stream().map(element -> PgArrayParser.parseTypedArrayElement(element, elementType, valueParser)).collect(Collectors.toList());
            return answer;
        }
        throw new IllegalArgumentException("Unexpected structure from PgArrayParser");
    }

    private static char getDelimiterForType(PostgresDataType elementType) {
        return elementType == PostgresDataType.BOX ? (char)';' : ',';
    }

    private static Object parseTypedArrayElement(Object arrayElement, PostgresDataType elementType, ValueParser valueParser) {
        if (arrayElement == null) {
            return null;
        }
        if (arrayElement instanceof List) {
            List nestedArray = (List)arrayElement;
            return nestedArray.stream().map(element -> PgArrayParser.parseTypedArrayElement(element, elementType, valueParser)).collect(Collectors.toList());
        }
        return valueParser.parse(elementType, arrayElement.toString());
    }

    public static List<Object> parseRawArray(String arrayString, char delimiter) {
        if (arrayString == null) {
            return null;
        }
        return PgArrayParser.parseArrayString(arrayString, delimiter);
    }

    private static List<Object> parseArrayString(String arrayString, char delimiter) {
        if (arrayString == null || arrayString.isEmpty()) {
            return new ArrayList<Object>();
        }
        if (arrayString.charAt(0) != '{' || arrayString.charAt(arrayString.length() - 1) != '}') {
            throw new IllegalArgumentException("Array string must start and end with curly braces.");
        }
        return PgArrayParser.parseArrayElements(arrayString, 1, arrayString.length() - 1, delimiter);
    }

    private static List<Object> parseArrayElements(String arrayString, int offset, int end, char delimiter) {
        ArrayList<Object> result = new ArrayList<Object>();
        StringBuilder currentElement = new StringBuilder();
        boolean inQuotes = false;
        int nestedLevel = 0;
        boolean escaped = false;
        for (int i = offset; i <= end; ++i) {
            char c;
            char c2 = c = i < end ? arrayString.charAt(i) : (char)'\u0000';
            if (escaped) {
                currentElement.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                currentElement.append(c);
                continue;
            }
            if (c == '\"') {
                if (!inQuotes) {
                    inQuotes = true;
                } else if (i + 1 < end && arrayString.charAt(i + 1) == delimiter) {
                    inQuotes = false;
                }
                currentElement.append(c);
                continue;
            }
            if (!inQuotes && (PgArrayParser.isElementEnd(c, delimiter, nestedLevel = PgArrayParser.updateNestedLevel(c, nestedLevel)) || c == '\u0000')) {
                PgArrayParser.addElement(result, currentElement.toString().trim(), delimiter);
                currentElement.setLength(0);
                continue;
            }
            currentElement.append(c);
        }
        if (currentElement.length() > 0) {
            PgArrayParser.addElement(result, currentElement.toString().trim(), delimiter);
        }
        return result;
    }

    private static int updateNestedLevel(char c, int nestedLevel) {
        if (c == '{') {
            return nestedLevel + 1;
        }
        if (c == '}') {
            return nestedLevel - 1;
        }
        return nestedLevel;
    }

    private static boolean isElementEnd(char c, char delimiter, int nestedLevel) {
        return c == delimiter && nestedLevel == 0;
    }

    private static void addElement(List<Object> result, String element, char delimiter) {
        if (element.isEmpty()) {
            return;
        }
        if (element.equalsIgnoreCase("NULL")) {
            result.add(null);
        } else if (element.startsWith("{") && element.endsWith("}")) {
            result.add(PgArrayParser.parseArrayElements(element, 1, element.length() - 1, delimiter));
        } else {
            result.add(PgArrayParser.unquoteString(element));
        }
    }

    private static String unquoteString(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
            s = s.replace("\\\\", "\\").replace("\\\"", "\"").replace("\\'", "'").replace("\\,", ",");
        }
        return s;
    }

    @FunctionalInterface
    public static interface ValueParser {
        public Object parse(PostgresDataType var1, String var2);
    }
}

