/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.coordination.partition;

import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.state.StreamProgressState;

public class StreamPartition
extends EnhancedSourcePartition<StreamProgressState> {
    public static final String PARTITION_TYPE = "STREAM";
    private final String dbIdentifier;
    private final StreamProgressState state;

    public StreamPartition(String dbIdentifier, StreamProgressState state) {
        this.dbIdentifier = dbIdentifier;
        this.state = state;
    }

    public StreamPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        this.dbIdentifier = sourcePartitionStoreItem.getSourcePartitionKey();
        this.state = (StreamProgressState)this.convertStringToPartitionProgressState(StreamProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.dbIdentifier;
    }

    public Optional<StreamProgressState> getProgressState() {
        if (this.state != null) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }
}

