/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum EngineType {
    MYSQL("mysql", EngineCategory.MYSQL, EnginePlatform.RDS),
    POSTGRES("postgresql", EngineCategory.POSTGRES, EnginePlatform.RDS),
    AURORA_MYSQL("aurora-mysql", EngineCategory.MYSQL, EnginePlatform.AURORA),
    AURORA_POSTGRES("aurora-postgresql", EngineCategory.POSTGRES, EnginePlatform.AURORA);

    private static final Map<String, EngineType> ENGINE_TYPE_MAP;
    private final String engine;
    private final EngineCategory category;
    private final EnginePlatform platform;

    private EngineType(String engine, EngineCategory category, EnginePlatform platform) {
        this.engine = engine;
        this.category = category;
        this.platform = platform;
    }

    public String toString() {
        return this.engine;
    }

    @JsonCreator
    public static EngineType fromString(String option) {
        return ENGINE_TYPE_MAP.get(option);
    }

    public boolean isAurora() {
        return this.platform == EnginePlatform.AURORA;
    }

    public boolean isRds() {
        return this.platform == EnginePlatform.RDS;
    }

    public boolean isMySql() {
        return this.category == EngineCategory.MYSQL;
    }

    public boolean isPostgres() {
        return this.category == EngineCategory.POSTGRES;
    }

    static {
        ENGINE_TYPE_MAP = Arrays.stream(EngineType.values()).collect(Collectors.toMap(value -> value.engine, value -> value));
    }

    public static enum EnginePlatform {
        RDS,
        AURORA;

    }

    public static enum EngineCategory {
        MYSQL,
        POSTGRES;

    }
}

