/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.handler;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataTypeHandler;
import org.opensearch.dataprepper.plugins.source.rds.utils.BytesHexConverter;
import org.opensearch.dataprepper.plugins.source.rds.utils.PgArrayParser;

public class BinaryTypeHandler
implements PostgresDataTypeHandler {
    @Override
    public Object handle(PostgresDataType columnType, String columnName, Object value) {
        if (!columnType.isBinary()) {
            throw new IllegalArgumentException("ColumnType is not Binary : " + String.valueOf((Object)columnType));
        }
        if (columnType.isSubCategoryArray()) {
            return PgArrayParser.parseTypedArray(value.toString(), PostgresDataType.getScalarType(columnType), this::parseBinaryValue);
        }
        return this.parseBinaryValue(columnType, value);
    }

    private Object parseBinaryValue(PostgresDataType columnType, Object value) {
        if (value instanceof Map) {
            Object data = ((Map)value).get("bytes");
            byte[] bytes = ((String)data).getBytes(StandardCharsets.ISO_8859_1);
            return "\\x" + BytesHexConverter.bytesToHex(bytes);
        }
        return value.toString();
    }
}

