/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.opensearch.dataprepper.aws.api.AwsConfig;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.sink.prometheus.configuration.PrometheusSinkConfiguration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

class PrometheusSigV4Signer {
    private static final String SERVICE_NAME = "aps";
    private final Aws4Signer signer = Aws4Signer.create();
    private final AwsCredentialsProvider credentialsProvider;
    private final PrometheusSinkConfiguration config;
    private final Region region;
    private final URI endpointUri;

    PrometheusSigV4Signer(@Nonnull AwsCredentialsSupplier awsCredentialsSupplier, @Nonnull PrometheusSinkConfiguration config, String url) {
        this.region = config.getAwsConfig().getAwsRegion();
        this.config = config;
        this.credentialsProvider = awsCredentialsSupplier.getProvider(PrometheusSigV4Signer.convertToCredentialOptions(config.getAwsConfig()));
        this.endpointUri = URI.create(url);
    }

    private static AwsCredentialsOptions convertToCredentialOptions(AwsConfig awsConfig) {
        if (awsConfig == null) {
            return AwsCredentialsOptions.builder().build();
        }
        return AwsCredentialsOptions.builder().withRegion(awsConfig.getAwsRegion()).withStsRoleArn(awsConfig.getAwsStsRoleArn()).withStsExternalId(awsConfig.getAwsStsExternalId()).withStsHeaderOverrides(awsConfig.getAwsStsHeaderOverrides()).build();
    }

    PrometheusSigV4Signer(@Nonnull AwsCredentialsSupplier awsCredentialsSupplier, @Nonnull PrometheusSinkConfiguration config) {
        this(awsCredentialsSupplier, config, config.getUrl());
    }

    SdkHttpFullRequest signQueryRequest(String query) {
        SdkHttpFullRequest unsignedRequest = SdkHttpFullRequest.builder().method(SdkHttpMethod.POST).uri(this.endpointUri).putHeader("Content-type", "application/x-www-form-urlencoded").putHeader("x-amz-content-sha256", "required").contentStreamProvider(() -> SdkBytes.fromString((String)query, (Charset)StandardCharsets.US_ASCII).asInputStream()).build();
        return this.signer.sign(unsignedRequest, Aws4SignerParams.builder().signingRegion(this.region).signingName(SERVICE_NAME).awsCredentials(this.credentialsProvider.resolveCredentials()).build());
    }

    SdkHttpFullRequest signRequest(SdkHttpFullRequest unsignedRequest) {
        return this.signer.sign(unsignedRequest, Aws4SignerParams.builder().signingRegion(this.region).signingName(SERVICE_NAME).awsCredentials(this.credentialsProvider.resolveCredentials()).build());
    }
}

