/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.personalize;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.sink.personalize.configuration.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.sink.personalize.configuration.PersonalizeSinkConfiguration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.personalizeevents.PersonalizeEventsClient;
import software.amazon.awssdk.services.personalizeevents.PersonalizeEventsClientBuilder;

final class ClientFactory {
    private ClientFactory() {
    }

    static PersonalizeEventsClient createPersonalizeEventsClient(PersonalizeSinkConfiguration personalizeSinkConfig, AwsCredentialsSupplier awsCredentialsSupplier) {
        AwsCredentialsOptions awsCredentialsOptions = ClientFactory.convertToCredentialsOptions(personalizeSinkConfig.getAwsAuthenticationOptions());
        AwsCredentialsProvider awsCredentialsProvider = awsCredentialsSupplier.getProvider(awsCredentialsOptions);
        return (PersonalizeEventsClient)((PersonalizeEventsClientBuilder)((PersonalizeEventsClientBuilder)((PersonalizeEventsClientBuilder)PersonalizeEventsClient.builder().region(ClientFactory.getRegion(personalizeSinkConfig, awsCredentialsSupplier))).credentialsProvider(awsCredentialsProvider)).overrideConfiguration(ClientFactory.createOverrideConfiguration(personalizeSinkConfig))).build();
    }

    private static ClientOverrideConfiguration createOverrideConfiguration(PersonalizeSinkConfiguration personalizeSinkConfig) {
        RetryPolicy retryPolicy = RetryPolicy.builder().numRetries(Integer.valueOf(personalizeSinkConfig.getMaxRetries())).build();
        return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build();
    }

    private static AwsCredentialsOptions convertToCredentialsOptions(AwsAuthenticationOptions awsAuthenticationOptions) {
        if (awsAuthenticationOptions == null) {
            return AwsCredentialsOptions.builder().build();
        }
        return AwsCredentialsOptions.builder().withRegion((Region)awsAuthenticationOptions.getAwsRegion().orElse(null)).withStsRoleArn(awsAuthenticationOptions.getAwsStsRoleArn()).withStsExternalId(awsAuthenticationOptions.getAwsStsExternalId()).withStsHeaderOverrides(awsAuthenticationOptions.getAwsStsHeaderOverrides()).build();
    }

    private static Region getRegion(PersonalizeSinkConfiguration personalizeSinkConfig, AwsCredentialsSupplier awsCredentialsSupplier) {
        Region defaultRegion = awsCredentialsSupplier.getDefaultRegion().orElse(null);
        if (personalizeSinkConfig.getAwsAuthenticationOptions() == null) {
            return defaultRegion;
        }
        return personalizeSinkConfig.getAwsAuthenticationOptions().getAwsRegion().orElse(defaultRegion);
    }
}

