/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.personalize;

import java.util.Collection;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.AbstractSink;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.plugins.sink.personalize.ClientFactory;
import org.opensearch.dataprepper.plugins.sink.personalize.PersonalizeSinkService;
import org.opensearch.dataprepper.plugins.sink.personalize.configuration.PersonalizeSinkConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.personalizeevents.PersonalizeEventsClient;

@DataPrepperPlugin(name="aws_personalize", pluginType=Sink.class, pluginConfigurationType=PersonalizeSinkConfiguration.class)
public class PersonalizeSink
extends AbstractSink<Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(PersonalizeSink.class);
    private final PersonalizeSinkConfiguration personalizeSinkConfig;
    private volatile boolean sinkInitialized;
    private final PersonalizeSinkService personalizeSinkService;
    private final SinkContext sinkContext;

    @DataPrepperPluginConstructor
    public PersonalizeSink(PluginSetting pluginSetting, PersonalizeSinkConfiguration personalizeSinkConfig, PluginFactory pluginFactory, SinkContext sinkContext, AwsCredentialsSupplier awsCredentialsSupplier) {
        super(pluginSetting);
        this.personalizeSinkConfig = personalizeSinkConfig;
        this.sinkContext = sinkContext;
        this.sinkInitialized = false;
        PersonalizeEventsClient personalizeEventsClient = ClientFactory.createPersonalizeEventsClient(personalizeSinkConfig, awsCredentialsSupplier);
        this.personalizeSinkService = new PersonalizeSinkService(personalizeSinkConfig, this.pluginMetrics);
    }

    public boolean isReady() {
        return this.sinkInitialized;
    }

    public void doInitialize() {
        this.sinkInitialized = true;
    }

    public void doOutput(Collection<Record<Event>> records) {
        this.personalizeSinkService.output(records);
    }
}

