/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.parse.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.micrometer.core.instrument.Counter;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.model.event.HandleFailedEventsOption;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.plugins.processor.parse.AbstractParseProcessor;
import org.opensearch.dataprepper.plugins.processor.parse.xml.ParseXmlProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="parse_xml", pluginType=Processor.class, pluginConfigurationType=ParseXmlProcessorConfig.class)
public class ParseXmlProcessor
extends AbstractParseProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ParseXmlProcessor.class);
    private static final String PARSE_ERRORS = "parseErrors";
    private final XmlMapper xmlMapper = new XmlMapper();
    private final Counter parseErrorsCounter;
    private final HandleFailedEventsOption handleFailedEventsOption;

    @DataPrepperPluginConstructor
    public ParseXmlProcessor(PluginMetrics pluginMetrics, ParseXmlProcessorConfig parseXmlProcessorConfig, ExpressionEvaluator expressionEvaluator, EventKeyFactory eventKeyFactory) {
        super(pluginMetrics, parseXmlProcessorConfig, expressionEvaluator, eventKeyFactory);
        this.handleFailedEventsOption = parseXmlProcessorConfig.getHandleFailedEventsOption();
        this.parseErrorsCounter = pluginMetrics.counter(PARSE_ERRORS);
    }

    @Override
    protected Optional<Map<String, Object>> readValue(String message, Event context) {
        try {
            return Optional.of((Map)this.xmlMapper.readValue(message, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (JsonProcessingException e) {
            if (this.handleFailedEventsOption.shouldLog()) {
                LOG.error(DataPrepperMarkers.SENSITIVE, "An exception occurred due to invalid XML while parsing [{}] due to {}", (Object)message, (Object)e.getMessage());
            }
            this.parseErrorsCounter.increment();
            return Optional.empty();
        }
        catch (Exception e) {
            if (this.handleFailedEventsOption.shouldLog()) {
                LOG.error(DataPrepperMarkers.SENSITIVE, "An exception occurred while using the parse_xml processor while parsing [{}]", (Object)message, (Object)e);
            }
            this.processingFailuresCounter.increment();
            return Optional.empty();
        }
    }
}

