/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.codec.json.JsonOutputCodecConfig;

@DataPrepperPlugin(name="json", pluginType=OutputCodec.class, pluginConfigurationType=JsonOutputCodecConfig.class)
public class JsonOutputCodec
implements OutputCodec {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String JSON = "json";
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final JsonOutputCodecConfig config;
    private JsonWriter deprecatedSupportWriter;

    @DataPrepperPluginConstructor
    public JsonOutputCodec(JsonOutputCodecConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
    }

    public String getExtension() {
        return JSON;
    }

    public OutputCodec.Writer createWriter(OutputStream outputStream, Event sampleEvent, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        return new JsonWriter(outputStream, codecContext);
    }

    public void start(OutputStream outputStream, Event event, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        this.deprecatedSupportWriter = new JsonWriter(outputStream, codecContext);
    }

    public void complete(OutputStream outputStream) throws IOException {
        this.deprecatedSupportWriter.complete();
    }

    public synchronized void writeEvent(Event event, OutputStream outputStream) throws IOException {
        this.deprecatedSupportWriter.writeEvent(event);
    }

    private class JsonWriter
    implements OutputCodec.Writer {
        private final JsonGenerator generator;
        private final OutputStream outputStream;
        private final OutputCodecContext codecContext;

        private JsonWriter(OutputStream outputStream, OutputCodecContext codecContext) throws IOException {
            this.outputStream = outputStream;
            this.codecContext = codecContext;
            this.generator = JSON_FACTORY.createGenerator(outputStream, JsonEncoding.UTF8);
            this.generator.writeStartObject();
            this.generator.writeFieldName(JsonOutputCodec.this.config.getKeyName());
            this.generator.writeStartArray();
        }

        public void writeEvent(Event event) throws IOException {
            Objects.requireNonNull(event);
            Map<String, Object> dataMap = this.getDataMapToSerialize(event);
            JsonOutputCodec.this.objectMapper.writeValue(this.generator, dataMap);
            this.generator.flush();
        }

        public void complete() throws IOException {
            this.generator.writeEndArray();
            this.generator.writeEndObject();
            this.generator.close();
            this.outputStream.flush();
            this.outputStream.close();
        }

        private Map<String, Object> getDataMapToSerialize(Event event) throws JsonProcessingException {
            Event modifiedEvent = this.codecContext.getTagsTargetKey() != null ? JsonOutputCodec.this.addTagsToEvent(event, this.codecContext.getTagsTargetKey()) : event;
            Map dataMap = modifiedEvent.toMap();
            if (this.codecContext.getIncludeKeys() != null && !this.codecContext.getIncludeKeys().isEmpty() || this.codecContext.getExcludeKeys() != null && !this.codecContext.getExcludeKeys().isEmpty()) {
                Map finalDataMap = dataMap;
                dataMap = dataMap.keySet().stream().filter(arg_0 -> ((OutputCodecContext)this.codecContext).shouldIncludeKey(arg_0)).collect(Collectors.toMap(Function.identity(), finalDataMap::get));
            }
            return dataMap;
        }
    }
}

