/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otlp;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.server.RetryInfoConfig;

public class OTLPSourceConfig {
    static final String REQUEST_TIMEOUT = "request_timeout";
    static final String PORT = "port";
    static final String LOGS_PATH = "logs_path";
    static final String METRICS_PATH = "metrics_path";
    static final String TRACES_PATH = "traces_path";
    static final String SSL = "ssl";
    static final String OUTPUT_FORMAT = "output_format";
    static final String LOGS_OUTPUT_FORMAT = "logs_output_format";
    static final String METRICS_OUTPUT_FORMAT = "metrics_output_format";
    static final String TRACES_OUTPUT_FORMAT = "traces_output_format";
    static final String USE_ACM_CERT_FOR_SSL = "use_acm_certificate_for_ssl";
    static final String ACM_CERT_ISSUE_TIME_OUT_MILLIS = "acm_certificate_timeout";
    static final String HEALTH_CHECK_SERVICE = "health_check_service";
    static final String PROTO_REFLECTION_SERVICE = "proto_reflection_service";
    static final String SSL_KEY_CERT_FILE = "ssl_certificate_file";
    static final String SSL_KEY_FILE = "ssl_key_file";
    static final String ACM_CERT_ARN = "acm_certificate_arn";
    static final String ACM_PRIVATE_KEY_PASSWORD = "acm_private_key_password";
    static final String AWS_REGION = "aws_region";
    static final String THREAD_COUNT = "thread_count";
    static final String MAX_CONNECTION_COUNT = "max_connection_count";
    static final String ENABLE_UNFRAMED_REQUESTS = "unframed_requests";
    static final String COMPRESSION = "compression";
    static final String RETRY_INFO = "retry_info";
    static final int DEFAULT_REQUEST_TIMEOUT = 10;
    static final int DEFAULT_PORT = 21893;
    static final int DEFAULT_THREAD_COUNT = 200;
    static final int DEFAULT_MAX_CONNECTION_COUNT = 500;
    static final boolean DEFAULT_SSL = true;
    static final boolean DEFAULT_ENABLED_UNFRAMED_REQUESTS = false;
    static final boolean DEFAULT_HEALTH_CHECK = false;
    static final boolean DEFAULT_PROTO_REFLECTION_SERVICE = false;
    static final boolean DEFAULT_USE_ACM_CERT_FOR_SSL = false;
    static final int DEFAULT_ACM_CERT_ISSUE_TIME_OUT = 120;
    private static final String S3_PREFIX = "s3://";
    static final String UNAUTHENTICATED_HEALTH_CHECK = "unauthenticated_health_check";
    @JsonProperty(value="request_timeout")
    @DurationMin(seconds=5L)
    @DurationMax(seconds=3600L)
    private @DurationMin(seconds=5L) @DurationMax(seconds=3600L) Duration requestTimeout = Duration.ofSeconds(10L);
    @JsonProperty(value="port")
    private int port = 21893;
    @JsonProperty(value="logs_path")
    @Size(min=1, message="logsPath length should be at least 1")
    private @Size(min=1, message="logsPath length should be at least 1") String logsPath;
    @JsonProperty(value="metrics_path")
    @Size(min=1, message="metricsPath length should be at least 1")
    private @Size(min=1, message="metricsPath length should be at least 1") String metricsPath;
    @JsonProperty(value="traces_path")
    @Size(min=1, message="tracesPath length should be at least 1")
    private @Size(min=1, message="tracesPath length should be at least 1") String tracesPath;
    @JsonProperty(value="health_check_service")
    private boolean healthCheck = false;
    @JsonProperty(value="proto_reflection_service")
    private boolean protoReflectionService = false;
    @JsonProperty(value="unframed_requests")
    private boolean enableUnframedRequests = false;
    @JsonProperty(value="ssl")
    private boolean ssl = true;
    @JsonProperty(value="output_format")
    private OTelOutputFormat outputFormat = OTelOutputFormat.OTEL;
    @JsonProperty(value="logs_output_format")
    private OTelOutputFormat logsOutputFormat = null;
    @JsonProperty(value="metrics_output_format")
    private OTelOutputFormat metricsOutputFormat = null;
    @JsonProperty(value="traces_output_format")
    private OTelOutputFormat tracesOutputFormat = null;
    @JsonProperty(value="use_acm_certificate_for_ssl")
    private boolean useAcmCertForSSL = false;
    @JsonProperty(value="acm_certificate_timeout")
    @DurationMin(seconds=5L)
    @DurationMax(seconds=3600L)
    private @DurationMin(seconds=5L) @DurationMax(seconds=3600L) Duration acmCertIssueTimeOutMillis = Duration.ofSeconds(120L);
    @JsonProperty(value="ssl_certificate_file")
    private String sslKeyCertChainFile;
    @JsonProperty(value="ssl_key_file")
    private String sslKeyFile;
    private boolean sslCertAndKeyFileInS3;
    @JsonProperty(value="acm_certificate_arn")
    private String acmCertificateArn;
    @JsonProperty(value="acm_private_key_password")
    private String acmPrivateKeyPassword;
    @JsonProperty(value="aws_region")
    private String awsRegion;
    @JsonProperty(value="thread_count")
    private int threadCount = 200;
    @JsonProperty(value="max_connection_count")
    private int maxConnectionCount = 500;
    @JsonProperty(value="authentication")
    private PluginModel authentication;
    @JsonProperty(value="unauthenticated_health_check")
    private boolean unauthenticatedHealthCheck = false;
    @JsonProperty(value="compression")
    private CompressionOption compression = CompressionOption.NONE;
    @JsonProperty(value="max_request_length")
    private ByteCount maxRequestLength;
    @JsonProperty(value="retry_info")
    private RetryInfoConfig retryInfo;

    @AssertTrue(message="logs_path should start with /")
    @AssertTrue(message="logs_path should start with /") boolean isLogsPathValid() {
        return this.logsPath == null || this.logsPath.startsWith("/");
    }

    @AssertTrue(message="metrics_path should start with /")
    @AssertTrue(message="metrics_path should start with /") boolean isMetricsPathValid() {
        return this.metricsPath == null || this.metricsPath.startsWith("/");
    }

    @AssertTrue(message="traces_path should start with /")
    @AssertTrue(message="traces_path should start with /") boolean isTracesPathValid() {
        return this.tracesPath == null || this.tracesPath.startsWith("/");
    }

    @AssertTrue(message="logs_path, metrics_path, and traces_path should be distinct")
    @AssertTrue(message="logs_path, metrics_path, and traces_path should be distinct") boolean arePathsDistinct() {
        if (this.logsPath == null || this.metricsPath == null || this.tracesPath == null) {
            return true;
        }
        return !this.logsPath.equals(this.metricsPath) && !this.logsPath.equals(this.tracesPath) && !this.metricsPath.equals(this.tracesPath);
    }

    public void validateAndInitializeCertAndKeyFileInS3() {
        boolean certAndKeyFileInS3 = false;
        if (this.useAcmCertForSSL) {
            this.validateSSLArgument(String.format("%s is enabled", USE_ACM_CERT_FOR_SSL), this.acmCertificateArn, ACM_CERT_ARN);
            this.validateSSLArgument(String.format("%s is enabled", USE_ACM_CERT_FOR_SSL), this.awsRegion, AWS_REGION);
        } else if (this.ssl) {
            this.validateSSLCertificateFiles();
            certAndKeyFileInS3 = this.isSSLCertificateLocatedInS3();
            if (certAndKeyFileInS3) {
                this.validateSSLArgument("The certificate and key files are located in S3", this.awsRegion, AWS_REGION);
            }
        }
        this.sslCertAndKeyFileInS3 = certAndKeyFileInS3;
    }

    private void validateSSLArgument(String sslTypeMessage, String argument, String argumentName) {
        if (StringUtils.isEmpty((CharSequence)argument)) {
            throw new IllegalArgumentException(String.format("%s, %s can not be empty or null", sslTypeMessage, argumentName));
        }
    }

    private void validateSSLCertificateFiles() {
        this.validateSSLArgument(String.format("%s is enabled", SSL), this.sslKeyCertChainFile, SSL_KEY_CERT_FILE);
        this.validateSSLArgument(String.format("%s is enabled", SSL), this.sslKeyFile, SSL_KEY_FILE);
    }

    private boolean isSSLCertificateLocatedInS3() {
        return this.sslKeyCertChainFile.toLowerCase().startsWith(S3_PREFIX) && this.sslKeyFile.toLowerCase().startsWith(S3_PREFIX);
    }

    public int getRequestTimeoutInMillis() {
        return (int)this.requestTimeout.toMillis();
    }

    public OTelOutputFormat getLogsOutputFormat() {
        return this.logsOutputFormat != null ? this.logsOutputFormat : this.outputFormat;
    }

    public OTelOutputFormat getMetricsOutputFormat() {
        return this.metricsOutputFormat != null ? this.metricsOutputFormat : this.outputFormat;
    }

    public OTelOutputFormat getTracesOutputFormat() {
        return this.tracesOutputFormat != null ? this.tracesOutputFormat : this.outputFormat;
    }

    public int getPort() {
        return this.port;
    }

    public String getLogsPath() {
        return this.logsPath;
    }

    public String getMetricsPath() {
        return this.metricsPath;
    }

    public String getTracesPath() {
        return this.tracesPath;
    }

    public boolean hasHealthCheck() {
        return this.healthCheck;
    }

    public boolean enableHttpHealthCheck() {
        return this.enableUnframedRequests() && this.hasHealthCheck();
    }

    public boolean hasProtoReflectionService() {
        return this.protoReflectionService;
    }

    public boolean enableUnframedRequests() {
        return this.enableUnframedRequests;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public boolean useAcmCertForSSL() {
        return this.useAcmCertForSSL;
    }

    public long getAcmCertIssueTimeOutMillis() {
        return this.acmCertIssueTimeOutMillis.toMillis();
    }

    public String getSslKeyCertChainFile() {
        return this.sslKeyCertChainFile;
    }

    public String getSslKeyFile() {
        return this.sslKeyFile;
    }

    public String getAcmCertificateArn() {
        return this.acmCertificateArn;
    }

    public String getAcmPrivateKeyPassword() {
        return this.acmPrivateKeyPassword;
    }

    public boolean isSslCertAndKeyFileInS3() {
        return this.sslCertAndKeyFileInS3;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    public PluginModel getAuthentication() {
        return this.authentication;
    }

    public boolean isUnauthenticatedHealthCheck() {
        return this.unauthenticatedHealthCheck;
    }

    public CompressionOption getCompression() {
        return this.compression;
    }

    public ByteCount getMaxRequestLength() {
        return this.maxRequestLength;
    }

    public RetryInfoConfig getRetryInfo() {
        return this.retryInfo;
    }
}

