/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.oteltracegroup;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.aws.api.AwsRequestSigningApache4Interceptor;
import org.opensearch.dataprepper.plugins.processor.oteltracegroup.AuthConfig;
import org.opensearch.dataprepper.plugins.processor.oteltracegroup.ConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.core.signer.Signer;

public class OpenSearchClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchClientFactory.class);
    private final ConnectionConfiguration connectionConfiguration;

    public static OpenSearchClientFactory fromConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        return new OpenSearchClientFactory(connectionConfiguration);
    }

    OpenSearchClientFactory(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    public RestHighLevelClient createRestHighLevelClient(AwsCredentialsSupplier awsCredentialsSupplier) {
        HttpHost[] httpHosts = new HttpHost[this.connectionConfiguration.getHosts().size()];
        int i = 0;
        for (String host : this.connectionConfiguration.getHosts()) {
            httpHosts[i] = HttpHost.create((String)host);
            ++i;
        }
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        if (this.connectionConfiguration.isAwsSigv4()) {
            this.attachSigV4(restClientBuilder, awsCredentialsSupplier);
        } else {
            this.attachUserCredentials(restClientBuilder);
        }
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> {
            if (this.connectionConfiguration.getConnectTimeout() != null) {
                requestConfigBuilder.setConnectTimeout(this.connectionConfiguration.getConnectTimeout().intValue());
            }
            if (this.connectionConfiguration.getSocketTimeout() != null) {
                requestConfigBuilder.setSocketTimeout(this.connectionConfiguration.getSocketTimeout().intValue());
            }
            return requestConfigBuilder;
        });
        return new RestHighLevelClient(restClientBuilder);
    }

    private void attachSigV4(RestClientBuilder restClientBuilder, AwsCredentialsSupplier awsCredentialsSupplier) {
        String awsRegion = this.connectionConfiguration.getAwsOption() == null ? this.connectionConfiguration.getAwsRegion() : this.connectionConfiguration.getAwsOption().getRegion();
        LOG.info("{} is set, will sign requests using AWSRequestSigningApacheInterceptor", (Object)"aws_sigv4");
        Aws4Signer aws4Signer = Aws4Signer.create();
        AwsCredentialsOptions awsCredentialsOptions = this.createAwsCredentialsOptions();
        AwsCredentialsProvider credentialsProvider = awsCredentialsSupplier.getProvider(awsCredentialsOptions);
        AwsRequestSigningApache4Interceptor httpRequestInterceptor = new AwsRequestSigningApache4Interceptor("es", (Signer)aws4Signer, credentialsProvider, awsRegion);
        restClientBuilder.setHttpClientConfigCallback(arg_0 -> this.lambda$attachSigV4$1((HttpRequestInterceptor)httpRequestInterceptor, arg_0));
    }

    public AwsCredentialsOptions createAwsCredentialsOptions() {
        String awsStsRoleArn = this.connectionConfiguration.getAwsOption() == null ? this.connectionConfiguration.getAwsStsRoleArn() : this.connectionConfiguration.getAwsOption().getStsRoleArn();
        String awsStsExternalId = this.connectionConfiguration.getAwsOption() == null ? this.connectionConfiguration.getAwsStsExternalId() : this.connectionConfiguration.getAwsOption().getStsExternalId();
        String awsRegion = this.connectionConfiguration.getAwsOption() == null ? this.connectionConfiguration.getAwsRegion() : this.connectionConfiguration.getAwsOption().getRegion();
        Map<String, String> awsStsHeaderOverrides = this.connectionConfiguration.getAwsOption() == null ? this.connectionConfiguration.getAwsStsHeaderOverrides() : this.connectionConfiguration.getAwsOption().getStsHeaderOverrides();
        AwsCredentialsOptions awsCredentialsOptions = AwsCredentialsOptions.builder().withStsRoleArn(awsStsRoleArn).withStsExternalId(awsStsExternalId).withRegion(awsRegion).withStsHeaderOverrides(awsStsHeaderOverrides).build();
        return awsCredentialsOptions;
    }

    private void attachUserCredentials(RestClientBuilder restClientBuilder) {
        AuthConfig authConfig = this.connectionConfiguration.getAuthConfig();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (authConfig != null) {
            if (authConfig.getUsername() != null) {
                LOG.info("Using the authentication provided in the config.");
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(authConfig.getUsername(), authConfig.getPassword()));
            }
        } else {
            String username = this.connectionConfiguration.getUsername();
            String password = this.connectionConfiguration.getPassword();
            if (username != null) {
                LOG.info("Using the username provided in the config.");
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        restClientBuilder.setHttpClientConfigCallback(arg_0 -> this.lambda$attachUserCredentials$2((CredentialsProvider)credentialsProvider, arg_0));
    }

    private void setHttpProxyIfApplicable(HttpAsyncClientBuilder httpClientBuilder) {
        Optional.ofNullable(this.connectionConfiguration.getProxy()).ifPresent(p -> {
            HttpHost httpProxyHost = HttpHost.create((String)p);
            this.checkProxyPort(httpProxyHost.getPort());
            httpClientBuilder.setProxy(httpProxyHost);
        });
    }

    private void checkProxyPort(int port) {
        if (!ConnectionConfiguration.VALID_PORT_RANGE.isValidIntValue(port)) {
            throw new IllegalArgumentException("Invalid or missing proxy port.");
        }
    }

    private void attachSSLContext(HttpAsyncClientBuilder httpClientBuilder) {
        Path certPath = this.connectionConfiguration.getCertPath();
        SSLContext sslContext = certPath != null ? this.getCAStrategy(certPath) : this.getTrustAllStrategy();
        httpClientBuilder.setSSLContext(sslContext);
        if (this.connectionConfiguration.isInsecure()) {
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
    }

    private SSLContext getCAStrategy(Path certPath) {
        LOG.info("Using the cert provided in the config.");
        try {
            Certificate trustedCa;
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            try (InputStream is = Files.newInputStream(certPath, new OpenOption[0]);){
                trustedCa = factory.generateCertificate(is);
            }
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
            return sslContextBuilder.build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private SSLContext getTrustAllStrategy() {
        LOG.info("Using the trust all strategy");
        TrustAllStrategy trustStrategy = new TrustAllStrategy();
        try {
            return SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)trustStrategy).build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$attachUserCredentials$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        this.attachSSLContext(httpClientBuilder);
        this.setHttpProxyIfApplicable(httpClientBuilder);
        return httpClientBuilder;
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$attachSigV4$1(HttpRequestInterceptor httpRequestInterceptor, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.addInterceptorLast(httpRequestInterceptor);
        this.attachSSLContext(httpClientBuilder);
        this.setHttpProxyIfApplicable(httpClientBuilder);
        return httpClientBuilder;
    }
}

