/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otelmetrics;

import com.linecorp.armeria.server.Server;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.opentelemetry.proto.collector.metrics.v1.MetricsServiceGrpc;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.opensearch.dataprepper.armeria.authentication.GrpcAuthenticationProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.otel.codec.OTelMetricDecoder;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoOpensearchCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoStandardCodec;
import org.opensearch.dataprepper.plugins.server.CreateServer;
import org.opensearch.dataprepper.plugins.server.ServerConfiguration;
import org.opensearch.dataprepper.plugins.source.otelmetrics.ConvertConfiguration;
import org.opensearch.dataprepper.plugins.source.otelmetrics.OTelMetricsGrpcService;
import org.opensearch.dataprepper.plugins.source.otelmetrics.OTelMetricsSourceConfig;
import org.opensearch.dataprepper.plugins.source.otelmetrics.certificate.CertificateProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="otel_metrics_source", pluginType=Source.class, pluginConfigurationType=OTelMetricsSourceConfig.class)
public class OTelMetricsSource
implements Source<Record<? extends Metric>> {
    private static final String PLUGIN_NAME = "otel_metrics_source";
    private static final Logger LOG = LoggerFactory.getLogger(OTelMetricsSource.class);
    static final String SERVER_CONNECTIONS = "serverConnections";
    private final OTelMetricsSourceConfig oTelMetricsSourceConfig;
    private final String pipelineName;
    private final PluginMetrics pluginMetrics;
    private final GrpcAuthenticationProvider authenticationProvider;
    private final CertificateProviderFactory certificateProviderFactory;
    private Server server;
    private final ByteDecoder byteDecoder;

    @DataPrepperPluginConstructor
    public OTelMetricsSource(OTelMetricsSourceConfig oTelMetricsSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, PipelineDescription pipelineDescription) {
        this(oTelMetricsSourceConfig, pluginMetrics, pluginFactory, new CertificateProviderFactory(oTelMetricsSourceConfig), pipelineDescription);
    }

    OTelMetricsSource(OTelMetricsSourceConfig oTelMetricsSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, CertificateProviderFactory certificateProviderFactory, PipelineDescription pipelineDescription) {
        oTelMetricsSourceConfig.validateAndInitializeCertAndKeyFileInS3();
        this.oTelMetricsSourceConfig = oTelMetricsSourceConfig;
        this.pluginMetrics = pluginMetrics;
        this.certificateProviderFactory = certificateProviderFactory;
        this.pipelineName = pipelineDescription.getPipelineName();
        this.authenticationProvider = this.createAuthenticationProvider(pluginFactory);
        this.byteDecoder = new OTelMetricDecoder(oTelMetricsSourceConfig.getOutputFormat());
    }

    public ByteDecoder getDecoder() {
        return this.byteDecoder;
    }

    public void start(Buffer<Record<? extends Metric>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer provided is null");
        }
        if (this.server == null) {
            OTelMetricsGrpcService oTelMetricsGrpcService = new OTelMetricsGrpcService((int)((double)this.oTelMetricsSourceConfig.getRequestTimeoutInMillis() * 0.8), (OTelProtoCodec.OTelProtoDecoder)(this.oTelMetricsSourceConfig.getOutputFormat() == OTelOutputFormat.OPENSEARCH ? new OTelProtoOpensearchCodec.OTelProtoDecoder() : new OTelProtoStandardCodec.OTelProtoDecoder()), buffer, this.pluginMetrics);
            ServerConfiguration serverConfiguration = ConvertConfiguration.convertConfiguration(this.oTelMetricsSourceConfig);
            CreateServer createServer = new CreateServer(serverConfiguration, LOG, this.pluginMetrics, PLUGIN_NAME, this.pipelineName);
            CertificateProvider certificateProvider = null;
            if (this.oTelMetricsSourceConfig.isSsl() || this.oTelMetricsSourceConfig.useAcmCertForSSL()) {
                certificateProvider = this.certificateProviderFactory.getCertificateProvider();
            }
            MethodDescriptor methodDescriptor = MetricsServiceGrpc.getExportMethod();
            this.server = createServer.createGRPCServer(this.authenticationProvider, (BindableService)oTelMetricsGrpcService, certificateProvider, methodDescriptor);
            this.pluginMetrics.gauge(SERVER_CONNECTIONS, (Object)this.server, Server::numConnections);
        }
        try {
            this.server.start().get();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        LOG.info("Started otel_metrics_source...");
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop().get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new RuntimeException(ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
        }
        LOG.info("Stopped otel_metrics_source.");
    }

    private GrpcAuthenticationProvider createAuthenticationProvider(PluginFactory pluginFactory) {
        PluginModel authenticationConfiguration = this.oTelMetricsSourceConfig.getAuthentication();
        if (authenticationConfiguration == null || authenticationConfiguration.getPluginName().equals("unauthenticated")) {
            LOG.warn("Creating otel-metrics-source without authentication. This is not secure.");
            LOG.warn("In order to set up Http Basic authentication for the otel-metrics-source, go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-metrics-source#authentication-configurations");
        }
        PluginSetting authenticationPluginSetting = authenticationConfiguration != null ? new PluginSetting(authenticationConfiguration.getPluginName(), authenticationConfiguration.getPluginSettings()) : new PluginSetting("unauthenticated", Collections.emptyMap());
        authenticationPluginSetting.setPipelineName(this.pipelineName);
        return (GrpcAuthenticationProvider)pluginFactory.loadPlugin(GrpcAuthenticationProvider.class, authenticationPluginSetting, new Object[0]);
    }
}

