/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otelmetrics;

import io.micrometer.core.instrument.Counter;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.metric.JacksonMetric;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoOpensearchCodec;
import org.opensearch.dataprepper.plugins.processor.otelmetrics.OtelMetricsRawProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="otel_metrics", deprecatedName="otel_metrics_raw_processor", pluginType=Processor.class, pluginConfigurationType=OtelMetricsRawProcessorConfig.class)
public class OTelMetricsRawProcessor
extends AbstractProcessor<Record<?>, Record<? extends Metric>> {
    private static final Logger LOG = LoggerFactory.getLogger(OTelMetricsRawProcessor.class);
    public static final String RECORDS_DROPPED_METRICS_RAW = "recordsDroppedMetricsRaw";
    private final OtelMetricsRawProcessorConfig otelMetricsRawProcessorConfig;
    private final boolean flattenAttributesFlag;
    private final Counter recordsDroppedMetricsRawCounter;

    @DataPrepperPluginConstructor
    public OTelMetricsRawProcessor(PluginSetting pluginSetting, OtelMetricsRawProcessorConfig otelMetricsRawProcessorConfig) {
        super(pluginSetting);
        this.otelMetricsRawProcessorConfig = otelMetricsRawProcessorConfig;
        this.recordsDroppedMetricsRawCounter = this.pluginMetrics.counter(RECORDS_DROPPED_METRICS_RAW);
        this.flattenAttributesFlag = otelMetricsRawProcessorConfig.getFlattenAttributesFlag();
    }

    private void modifyRecord(Record<? extends Metric> record, boolean flattenAttributes, boolean calcualteHistogramBuckets, boolean calcualteExponentialHistogramBuckets) {
        Event event = (Event)record.getData();
        if (!flattenAttributes) {
            ((JacksonMetric)record.getData()).setFlattenAttributes(false);
        }
        if (!calcualteHistogramBuckets && event.get("buckets", List.class) != null) {
            event.delete("buckets");
        }
        if (!calcualteExponentialHistogramBuckets) {
            if (event.get("positiveBuckets", List.class) != null) {
                event.delete("positiveBuckets");
            }
            if (event.get("negativeBuckets", List.class) != null) {
                event.delete("negativeBuckets");
            }
        }
    }

    public Collection<Record<? extends Metric>> doExecute(Collection<Record<?>> records) {
        ArrayList<Record<? extends Metric>> recordsOut = new ArrayList<Record<? extends Metric>>();
        OTelProtoOpensearchCodec.OTelProtoDecoder otelProtoDecoder = new OTelProtoOpensearchCodec.OTelProtoDecoder();
        AtomicInteger droppedCounter = new AtomicInteger(0);
        for (Record<?> rec : records) {
            if (rec.getData() instanceof Event) {
                Record<?> newRecord = rec;
                if (!(this.otelMetricsRawProcessorConfig.getFlattenAttributesFlag().booleanValue() && this.otelMetricsRawProcessorConfig.getCalculateHistogramBuckets().booleanValue() && this.otelMetricsRawProcessorConfig.getCalculateExponentialHistogramBuckets().booleanValue())) {
                    this.modifyRecord(newRecord, this.otelMetricsRawProcessorConfig.getFlattenAttributesFlag(), this.otelMetricsRawProcessorConfig.getCalculateHistogramBuckets(), this.otelMetricsRawProcessorConfig.getCalculateExponentialHistogramBuckets());
                }
                recordsOut.add(newRecord);
            }
            if (!(rec.getData() instanceof ExportMetricsServiceRequest)) continue;
            ExportMetricsServiceRequest request = (ExportMetricsServiceRequest)rec.getData();
            recordsOut.addAll(otelProtoDecoder.parseExportMetricsServiceRequest(request, droppedCounter, this.otelMetricsRawProcessorConfig.getExponentialHistogramMaxAllowedScale(), Instant.now(), this.otelMetricsRawProcessorConfig.getCalculateHistogramBuckets().booleanValue(), this.otelMetricsRawProcessorConfig.getCalculateExponentialHistogramBuckets().booleanValue(), this.flattenAttributesFlag));
        }
        this.recordsDroppedMetricsRawCounter.increment((double)droppedCounter.get());
        return recordsOut;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

