/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.obfuscation;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.annotations.UsesDataPrepperPlugin;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugins.processor.obfuscation.action.ObfuscationAction;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>obfuscate</code> processor enables obfuscation of fields inside your documents in order to protect sensitive data.")
public class ObfuscationProcessorConfig {
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="The source key to obfuscate. Default action is to mask with <code>*</code>.")
    @NotEmpty
    @NotNull
    @ExampleValues(value={@ExampleValues.Example(value="log", description="The 'log' field in the input data will be obfuscated.")})
    private String source;
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="The new field in which to store the obfuscated value. This leaves the original source field unchanged. When no <code>target</code> is provided, the source field updates with the obfuscated value.")
    @ExampleValues(value={@ExampleValues.Example(value="newLog", description="The 'newLog' field in the output data will have the input data obfuscated according to the other configurations that were set.")})
    private String target;
    @JsonProperty(value="patterns")
    @JsonPropertyDescription(value="A list of regex patterns that allow you to obfuscate specific parts of a field. Only parts that match the regex pattern will obfuscate. When not provided, the processor obfuscates the whole field.")
    @ExampleValues(value={@ExampleValues.Example(value="regex", description="Generic regex pattern.")})
    private List<String> patterns;
    @JsonProperty(value="action")
    @JsonPropertyDescription(value="The obfuscation action. Available actions include <code>hash</code> and <code>mask</code>.")
    @UsesDataPrepperPlugin(pluginType=ObfuscationAction.class)
    private PluginModel action;
    @JsonProperty(value="single_word_only")
    @JsonPropertyDescription(value="When set to <code>true</code>, a word boundary <code>\b</code>is added to the pattern, which causes obfuscation to be applied only to words that are standalone in the input text. By default, it is false, meaning obfuscation patterns are applied to all occurrences.")
    private boolean singleWordOnly = false;
    @JsonProperty(value="tags_on_match_failure")
    @JsonPropertyDescription(value="The tag to add to an event if the <code>obfuscate</code> processor fails to match the pattern.")
    private List<String> tagsOnMatchFailure;
    @JsonProperty(value="obfuscate_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> such as <code>/is_testing_data == true</code>. If specified, the <code>obfuscate</code> processor will only run on events when the expression evaluates to true. ")
    @ExampleValues(value={@ExampleValues.Example(value="/some_key != null", description="Only runs the obfuscate processor on the Event if the existing key some_key is not null.")})
    private String obfuscateWhen;

    public ObfuscationProcessorConfig() {
    }

    public ObfuscationProcessorConfig(String source, List<String> patterns, String target, PluginModel action, List<String> tagsOnMatchFailure, boolean singleWordOnly) {
        this.source = source;
        this.patterns = patterns;
        this.target = target;
        this.action = action;
        this.tagsOnMatchFailure = tagsOnMatchFailure;
        this.singleWordOnly = singleWordOnly;
    }

    public String getSource() {
        return this.source;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public String getTarget() {
        return this.target;
    }

    public PluginModel getAction() {
        return this.action;
    }

    public String getObfuscateWhen() {
        return this.obfuscateWhen;
    }

    public List<String> getTagsOnMatchFailure() {
        return this.tagsOnMatchFailure;
    }

    public boolean getSingleWordOnly() {
        return this.singleWordOnly;
    }

    void validateObfuscateWhen(ExpressionEvaluator expressionEvaluator) {
        if (this.obfuscateWhen != null && !expressionEvaluator.isValidExpressionStatement(this.obfuscateWhen).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("obfuscate_when value %s is not a valid Data Prepper expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", this.obfuscateWhen));
        }
    }
}

