/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.obfuscation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.obfuscation.CommonPattern;
import org.opensearch.dataprepper.plugins.processor.obfuscation.ObfuscationProcessorConfig;
import org.opensearch.dataprepper.plugins.processor.obfuscation.action.MaskAction;
import org.opensearch.dataprepper.plugins.processor.obfuscation.action.MaskActionConfig;
import org.opensearch.dataprepper.plugins.processor.obfuscation.action.ObfuscationAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="obfuscate", pluginType=Processor.class, pluginConfigurationType=ObfuscationProcessorConfig.class)
public class ObfuscationProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final String COMMON_PATTERN_REGEX = "^%\\{([A-Z_0-9]+)}$";
    private static final Logger LOG = LoggerFactory.getLogger(ObfuscationProcessor.class);
    private final ExpressionEvaluator expressionEvaluator;
    private final ObfuscationProcessorConfig obfuscationProcessorConfig;
    private final String source;
    private final String target;
    private final boolean singleWordOnly;
    private final List<Pattern> patterns;
    private final ObfuscationAction action;

    /*
     * WARNING - void declaration
     */
    @DataPrepperPluginConstructor
    public ObfuscationProcessor(PluginMetrics pluginMetrics, ObfuscationProcessorConfig config, PluginFactory pluginFactory, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.source = config.getSource();
        this.target = config.getTarget();
        this.patterns = new ArrayList<Pattern>();
        this.expressionEvaluator = expressionEvaluator;
        this.obfuscationProcessorConfig = config;
        this.singleWordOnly = config.getSingleWordOnly();
        config.validateObfuscateWhen(expressionEvaluator);
        PluginModel actionPlugin = config.getAction();
        if (actionPlugin == null) {
            this.action = this.createDefaultAction();
        } else {
            PluginSetting actionPluginSettings = new PluginSetting(actionPlugin.getPluginName(), actionPlugin.getPluginSettings());
            this.action = (ObfuscationAction)pluginFactory.loadPlugin(ObfuscationAction.class, actionPluginSettings, new Object[0]);
        }
        if (config.getPatterns() != null) {
            for (String string : config.getPatterns()) {
                void var7_7;
                Pattern pattern = Pattern.compile(COMMON_PATTERN_REGEX);
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    try {
                        CommonPattern cp = CommonPattern.valueOf(matcher.group(1));
                        String string2 = cp.getExpr();
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error("Unable to find a predefined pattern for '{}'", (Object)matcher.group(1));
                        throw new InvalidPluginConfigurationException("Unable to find a predefined pattern for \"" + string + "\".");
                    }
                }
                if (this.singleWordOnly) {
                    void var7_10;
                    String string3 = "\\b" + (String)var7_10 + "\\b";
                }
                try {
                    Pattern p = Pattern.compile((String)var7_7);
                    this.patterns.add(p);
                }
                catch (Exception e) {
                    LOG.error(DataPrepperMarkers.NOISY, e.getMessage());
                    LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage(e.getMessage()).log();
                    throw new InvalidPluginConfigurationException("Invalid Pattern: \"" + (String)var7_7 + "\" for source field " + this.source);
                }
            }
        }
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                String newValue;
                if (this.obfuscationProcessorConfig.getObfuscateWhen() != null && !this.expressionEvaluator.evaluateConditional(this.obfuscationProcessorConfig.getObfuscateWhen(), recordEvent).booleanValue() || !recordEvent.containsKey(this.source)) continue;
                String rawValue = (String)recordEvent.get(this.source, String.class);
                if (rawValue.equals(newValue = this.action.obfuscate(rawValue, this.patterns, record))) {
                    recordEvent.getMetadata().addTags(this.obfuscationProcessorConfig.getTagsOnMatchFailure());
                }
                if (this.target == null || this.target.isEmpty()) {
                    recordEvent.put(this.source, (Object)newValue);
                    continue;
                }
                recordEvent.put(this.target, (Object)newValue);
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.EVENT, "There was an exception while processing Event [{}]", (Object)recordEvent, (Object)e);
            }
        }
        return records;
    }

    private ObfuscationAction createDefaultAction() {
        LOG.debug("Create a default mask action");
        MaskActionConfig config = new MaskActionConfig();
        return new MaskAction(config);
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

