/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutatestring;

import java.util.Objects;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.plugins.processor.mutatestring.AbstractStringProcessor;
import org.opensearch.dataprepper.plugins.processor.mutatestring.ReplaceStringProcessorConfig;

@DataPrepperPlugin(name="replace_string", pluginType=Processor.class, pluginConfigurationType=ReplaceStringProcessorConfig.class)
public class ReplaceStringProcessor
extends AbstractStringProcessor<ReplaceStringProcessorConfig.Entry> {
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public ReplaceStringProcessor(PluginMetrics pluginMetrics, ReplaceStringProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics, config);
        this.expressionEvaluator = expressionEvaluator;
        for (ReplaceStringProcessorConfig.Entry entry : config.getEntries()) {
            if (entry.getReplaceWhen() == null || expressionEvaluator.isValidExpressionStatement(entry.getReplaceWhen()).booleanValue()) continue;
            throw new InvalidPluginConfigurationException(String.format("substitute_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getReplaceWhen()));
        }
    }

    @Override
    protected void performKeyAction(Event recordEvent, ReplaceStringProcessorConfig.Entry entry, String value) {
        if (Objects.nonNull(entry.getReplaceWhen()) && !this.expressionEvaluator.evaluateConditional(entry.getReplaceWhen(), recordEvent).booleanValue()) {
            return;
        }
        String newValue = value.replace(entry.getFrom(), entry.getTo());
        recordEvent.put(entry.getSource(), (Object)newValue);
    }

    @Override
    protected EventKey getKey(ReplaceStringProcessorConfig.Entry entry) {
        return entry.getSource();
    }
}

