/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.event.exceptions.EventKeyNotFoundException;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.AddEntryProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="add_entries", pluginType=Processor.class, pluginConfigurationType=AddEntryProcessorConfig.class)
public class AddEntryProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddEntryProcessor.class);
    private final List<AddEntryProcessorConfig.Entry> entries;
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public AddEntryProcessor(PluginMetrics pluginMetrics, AddEntryProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.entries = config.getEntries();
        this.expressionEvaluator = expressionEvaluator;
        config.getEntries().forEach(entry -> {
            if (entry.getAddWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getAddWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("add_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getAddWhen()));
            }
            if (entry.getAddToElementWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getAddToElementWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("add_to_element_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getAddWhen()));
            }
        });
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                for (AddEntryProcessorConfig.Entry entry : this.entries) {
                    if (Objects.nonNull(entry.getAddWhen()) && !this.expressionEvaluator.evaluateConditional(entry.getAddWhen(), recordEvent).booleanValue()) continue;
                    try {
                        String key = entry.getKey() == null ? null : recordEvent.formatString(entry.getKey(), this.expressionEvaluator);
                        String metadataKey = entry.getMetadataKey();
                        String iterateOn = entry.getIterateOn();
                        if (Objects.isNull(iterateOn)) {
                            this.handleWithoutIterateOn(entry, recordEvent, key, metadataKey);
                            continue;
                        }
                        if (Objects.isNull(key)) continue;
                        this.handleWithIterateOn(entry, recordEvent, iterateOn, key);
                    }
                    catch (Exception e) {
                        LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("Error adding entry to record [{}] with iterate_on [{}], add_to_element_when [{}], key [{}], metadataKey [{}], value_expression [{}] format [{}], value [{}]").addArgument((Object)recordEvent).addArgument((Object)entry.getIterateOn()).addArgument((Object)entry.getAddToElementWhen()).addArgument((Object)entry.getKey()).addArgument((Object)entry.getMetadataKey()).addArgument((Object)entry.getValueExpression()).addArgument((Object)entry.getFormat()).addArgument(entry.getValue()).log();
                    }
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private void handleWithoutIterateOn(AddEntryProcessorConfig.Entry entry, Event recordEvent, String key, String metadataKey) {
        Object value = this.retrieveValue(entry, recordEvent);
        if (!Objects.isNull(key)) {
            if (!recordEvent.containsKey(key) || entry.getOverwriteIfKeyExists()) {
                recordEvent.put(key, value);
            } else if (recordEvent.containsKey(key) && entry.getAppendIfKeyExists()) {
                this.mergeValueToEvent(recordEvent, key, value);
            }
        } else {
            Map attributes = recordEvent.getMetadata().getAttributes();
            if (!attributes.containsKey(metadataKey) || entry.getOverwriteIfKeyExists()) {
                recordEvent.getMetadata().setAttribute(metadataKey, value);
            } else if (attributes.containsKey(metadataKey) && entry.getAppendIfKeyExists()) {
                this.mergeValueToEventMetadata(recordEvent, metadataKey, value);
            }
        }
    }

    private void handleWithIterateOn(AddEntryProcessorConfig.Entry entry, Event recordEvent, String iterateOn, String key) {
        List iterateOnList = (List)recordEvent.get(iterateOn, List.class);
        if (iterateOnList != null) {
            for (Map item : iterateOnList) {
                JacksonEvent context = JacksonEvent.builder().withEventMetadata(recordEvent.getMetadata()).withData((Object)item).build();
                if (entry.getAddToElementWhen() != null && !this.expressionEvaluator.evaluateConditional(entry.getAddToElementWhen(), recordEvent).booleanValue()) continue;
                Object value = this.retrieveValue(entry, (Event)context);
                if (!item.containsKey(key) || entry.getOverwriteIfKeyExists()) {
                    item.put(key, value);
                    continue;
                }
                if (!item.containsKey(key) || !entry.getAppendIfKeyExists()) continue;
                this.mergeValueToMap(item, key, value);
            }
            recordEvent.put(iterateOn, (Object)iterateOnList);
        }
    }

    private Object retrieveValue(AddEntryProcessorConfig.Entry entry, Event context) {
        Object value;
        if (!Objects.isNull(entry.getValueExpression())) {
            value = this.expressionEvaluator.evaluate(entry.getValueExpression(), context);
        } else if (!Objects.isNull(entry.getFormat())) {
            try {
                value = context.formatString(entry.getFormat());
            }
            catch (EventKeyNotFoundException e) {
                value = null;
            }
        } else {
            value = entry.getValue();
        }
        return value;
    }

    private void mergeValueToEvent(Event recordEvent, String key, Object value) {
        this.mergeValue(value, () -> recordEvent.get(key, Object.class), newValue -> recordEvent.put(key, newValue));
    }

    private void mergeValueToEventMetadata(Event recordEvent, String key, Object value) {
        this.mergeValue(value, () -> recordEvent.getMetadata().getAttribute(key), newValue -> recordEvent.getMetadata().setAttribute(key, newValue));
    }

    private void mergeValueToMap(Map<String, Object> item, String key, Object value) {
        this.mergeValue(value, () -> item.get(key), newValue -> item.put(key, newValue));
    }

    private void mergeValue(Object value, Supplier<Object> getter, Consumer<Object> setter) {
        Object currentValue = getter.get();
        ArrayList<Object> mergedValue = new ArrayList<Object>();
        if (currentValue instanceof List) {
            mergedValue.addAll((List)currentValue);
        } else {
            mergedValue.add(currentValue);
        }
        mergedValue.add(value);
        setter.accept(mergedValue);
    }
}

