/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.common.TransformOption;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.RenameKeyProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="rename_keys", pluginType=Processor.class, pluginConfigurationType=RenameKeyProcessorConfig.class)
public class RenameKeyProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(RenameKeyProcessor.class);
    private final List<RenameKeyProcessorConfig.Entry> entries;
    private final ExpressionEvaluator expressionEvaluator;
    private final TransformOption transformOption;

    @DataPrepperPluginConstructor
    public RenameKeyProcessor(PluginMetrics pluginMetrics, RenameKeyProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.entries = config.getEntries();
        this.expressionEvaluator = expressionEvaluator;
        this.transformOption = config.getTransformOption();
        if (config.getEntries() != null) {
            config.getEntries().forEach(entry -> {
                if (entry.getRenameWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getRenameWhen()).booleanValue()) {
                    throw new InvalidPluginConfigurationException(String.format("rename_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getRenameWhen()));
                }
                if (entry.getFromKey() == null && entry.getFromKeyPattern() == null) {
                    throw new InvalidPluginConfigurationException("Either from_key or from_key_regex must be specified. ");
                }
                if (entry.getFromKey() != null && entry.getFromKeyPattern() != null) {
                    throw new InvalidPluginConfigurationException("Only one of from_key or from_key_regex should be specified.");
                }
            });
        }
    }

    private void transformEvent(Event event, Map<String, Object> map, String keyPrefix) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                if (entry.getValue() instanceof Map) {
                    this.transformEvent(event, (Map)entry.getValue(), keyPrefix + entry.getKey() + "/");
                }
                Object value = event.get(keyPrefix + entry.getKey(), Object.class);
                event.delete(keyPrefix + entry.getKey());
                event.put(keyPrefix + (String)this.transformOption.getTransformFunction().apply(entry.getKey()), value);
            }
            catch (Exception exception) {}
        }
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                if (this.transformOption != null && this.transformOption != TransformOption.NONE) {
                    this.transformEvent(recordEvent, recordEvent.toMap(), "");
                    continue;
                }
                block3: for (RenameKeyProcessorConfig.Entry entry : this.entries) {
                    if (Objects.nonNull(entry.getRenameWhen()) && !this.expressionEvaluator.evaluateConditional(entry.getRenameWhen(), recordEvent).booleanValue() || Objects.nonNull(entry.getFromKey()) && (entry.getFromKey().equals(entry.getToKey()) || !recordEvent.containsKey(entry.getFromKey())) || recordEvent.containsKey(entry.getToKey()) && !entry.getOverwriteIfToKeyExists()) continue;
                    if (Objects.nonNull(entry.getFromKey())) {
                        Object source = recordEvent.get(entry.getFromKey(), Object.class);
                        recordEvent.put(entry.getToKey(), source);
                        recordEvent.delete(entry.getFromKey());
                    }
                    if (!Objects.nonNull(entry.getFromKeyCompiledPattern())) continue;
                    Map eventMap = recordEvent.toMap();
                    Pattern fromKeyCompiledPattern = entry.getFromKeyCompiledPattern();
                    for (Map.Entry eventEntry : eventMap.entrySet()) {
                        String key = (String)eventEntry.getKey();
                        Object value = eventEntry.getValue();
                        if (!fromKeyCompiledPattern.matcher(key).matches()) continue;
                        recordEvent.put(entry.getToKey(), value);
                        recordEvent.delete(key);
                        if (entry.getOverwriteIfToKeyExists()) continue;
                        continue block3;
                    }
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

