/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.stream;

public class CheckpointStatus {
    private final String resumeToken;
    private final long recordCount;
    private AcknowledgmentStatus acknowledgeStatus;
    private final long createTimestamp;
    private Long acknowledgedTimestamp;

    public CheckpointStatus(String resumeToken, long recordCount, long createTimestamp) {
        this.resumeToken = resumeToken;
        this.recordCount = recordCount;
        this.acknowledgeStatus = AcknowledgmentStatus.NO_ACK;
        this.createTimestamp = createTimestamp;
    }

    public void setAcknowledgedTimestamp(Long acknowledgedTimestamp) {
        this.acknowledgedTimestamp = acknowledgedTimestamp;
    }

    public void setAcknowledged(AcknowledgmentStatus acknowledgmentStatus) {
        this.acknowledgeStatus = acknowledgmentStatus;
    }

    public String getResumeToken() {
        return this.resumeToken;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public boolean isPositiveAcknowledgement() {
        return this.acknowledgeStatus == AcknowledgmentStatus.POSITIVE_ACK;
    }

    public boolean isNegativeAcknowledgement() {
        return this.acknowledgeStatus == AcknowledgmentStatus.NEGATIVE_ACK;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public long getAcknowledgedTimestamp() {
        return this.acknowledgedTimestamp;
    }

    static enum AcknowledgmentStatus {
        POSITIVE_ACK,
        NEGATIVE_ACK,
        NO_ACK;

    }
}

