/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.plugins.mongo.configuration.AwsConfig;
import org.opensearch.dataprepper.plugins.mongo.configuration.CollectionConfig;

public class MongoDBSourceConfig {
    private static final int DEFAULT_PORT = 27017;
    private static final Boolean DEFAULT_INSECURE = false;
    private static final Boolean DEFAULT_INSECURE_DISABLE_VERIFICATION = false;
    private static final String DEFAULT_READ_PREFERENCE = "primaryPreferred";
    private static final Boolean DEFAULT_DIRECT_CONNECT = true;
    private static final Duration DEFAULT_ACKNOWLEDGEMENT_SET_TIMEOUT = Duration.ofHours(2L);
    @JsonProperty(value="host")
    @NotNull
    private String host;
    @JsonProperty(value="port")
    private int port = 27017;
    @JsonProperty(value="trust_store_file_path")
    private String trustStoreFilePath;
    @JsonProperty(value="trust_store_password")
    private String trustStorePassword;
    @JsonProperty(value="authentication")
    private AuthenticationConfig authenticationConfig;
    @JsonProperty(value="read_preference")
    private String readPreference = "primaryPreferred";
    @JsonProperty(value="collections")
    @Valid
    @NotNull
    @Size(min=1)
    private @Valid @NotNull @Size(min=1) List<CollectionConfig> collections = new ArrayList<CollectionConfig>();
    @JsonProperty(value="acknowledgments")
    private Boolean acknowledgments = false;
    @JsonProperty(value="s3_bucket")
    private String s3Bucket;
    @JsonProperty(value="s3_prefix")
    private String s3Prefix;
    @JsonProperty(value="s3_region")
    private String s3Region;
    @JsonProperty
    private Duration partitionAcknowledgmentTimeout;
    @JsonProperty(value="insecure")
    private Boolean insecure = DEFAULT_INSECURE;
    @JsonProperty(value="ssl_insecure_disable_verification")
    private Boolean sslInsecureDisableVerification = DEFAULT_INSECURE_DISABLE_VERIFICATION;
    @JsonProperty(value="direct_connection")
    private Boolean directConnection = DEFAULT_DIRECT_CONNECT;
    @JsonProperty(value="aws")
    @Valid
    private AwsConfig awsConfig;
    @JsonProperty(value="disable_s3_read_for_leader")
    private boolean disableS3ReadForLeader = false;
    @JsonProperty(value="id_key")
    private String idKey;

    public MongoDBSourceConfig() {
        this.partitionAcknowledgmentTimeout = DEFAULT_ACKNOWLEDGEMENT_SET_TIMEOUT;
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTrustStoreFilePath() {
        return this.trustStoreFilePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public Boolean getTls() {
        return this.insecure == false;
    }

    public Boolean getSslInsecureDisableVerification() {
        return this.sslInsecureDisableVerification;
    }

    public Boolean getDirectConnection() {
        return this.directConnection;
    }

    public List<CollectionConfig> getCollections() {
        return this.collections;
    }

    public String getReadPreference() {
        return this.readPreference;
    }

    public boolean isAcknowledgmentsEnabled() {
        return this.acknowledgments;
    }

    public Duration getPartitionAcknowledgmentTimeout() {
        return this.partitionAcknowledgmentTimeout;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getS3Prefix() {
        return this.s3Prefix;
    }

    public String getS3Region() {
        return this.s3Region;
    }

    public boolean isDisableS3ReadForLeader() {
        return this.disableS3ReadForLeader;
    }

    public String getIdKey() {
        return this.idKey;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public static class AuthenticationConfig {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

