/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.dlq;

import java.util.Objects;

public class MLBatchJobFailedDlqData {
    private final String s3Bucket;
    private final String s3Key;
    private final int status;
    private final String message;
    private final Object data;

    private MLBatchJobFailedDlqData(String s3Bucket, String s3Key, int status, String message, Object data) {
        Objects.requireNonNull(s3Bucket);
        this.s3Bucket = s3Bucket;
        Objects.requireNonNull(s3Key);
        this.s3Key = s3Key;
        this.status = status;
        Objects.requireNonNull(message);
        this.message = message;
        Objects.requireNonNull(data);
        this.data = data;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getS3Key() {
        return this.s3Key;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLBatchJobFailedDlqData that = (MLBatchJobFailedDlqData)o;
        return Objects.equals(this.s3Bucket, that.s3Bucket) && Objects.equals(this.s3Key, that.s3Key) && Objects.equals(this.status, that.status) && Objects.equals(this.message, that.message) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.s3Bucket + this.s3Key, this.status, this.message, this.data);
    }

    public String toString() {
        return "MLBatchJobFailedDlqData{s3Bucket='" + this.s3Bucket + "', s3Key='" + this.s3Key + "', status='" + this.status + "', message='" + this.message + "', data=" + String.valueOf(this.data) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String s3Bucket;
        private String s3Key;
        private int status = 0;
        private String message;
        private Object data;

        public Builder withS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public Builder withS3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withData(Object data) {
            this.data = data;
            return this;
        }

        public MLBatchJobFailedDlqData build() {
            return new MLBatchJobFailedDlqData(this.s3Bucket, this.s3Key, this.status, this.message, this.data);
        }
    }
}

