/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.common;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;

public interface MLBatchJobCreator {
    public static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    public static final Pattern JOB_NAME_PATTERN = Pattern.compile("[^a-zA-Z0-9-]");

    public void createMLBatchJob(List<Record<Event>> var1, List<Record<Event>> var2);

    default public String generateJobName() {
        String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMATTER);
        String instanceId = UUID.randomUUID().toString();
        String jobName = String.format("batch-job-%s-%s", timestamp, instanceId);
        jobName = JOB_NAME_PATTERN.matcher(jobName).replaceAll("");
        return jobName.substring(0, Math.min(63, jobName.length()));
    }

    default public void prepareForShutdown() {
    }

    default public boolean isReadyForShutdown() {
        return true;
    }

    default public void shutdown() {
    }

    default public void addProcessedBatchRecordsToResults(List<Record<Event>> resultRecords) {
    }

    default public void checkAndProcessBatch() {
    }
}

