/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source.processor;

import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;

public class KinesisInputOutputRecord {
    private Record<Event> dataPrepperRecord;
    private long incomingRecordSizeBytes;

    public static KinesisInputOutputRecordBuilder builder() {
        return new KinesisInputOutputRecordBuilder();
    }

    public Record<Event> getDataPrepperRecord() {
        return this.dataPrepperRecord;
    }

    public long getIncomingRecordSizeBytes() {
        return this.incomingRecordSizeBytes;
    }

    public KinesisInputOutputRecord(Record<Event> dataPrepperRecord, long incomingRecordSizeBytes) {
        this.dataPrepperRecord = dataPrepperRecord;
        this.incomingRecordSizeBytes = incomingRecordSizeBytes;
    }

    public static class KinesisInputOutputRecordBuilder {
        private Record<Event> dataPrepperRecord;
        private long incomingRecordSizeBytes;

        KinesisInputOutputRecordBuilder() {
        }

        public KinesisInputOutputRecordBuilder withDataPrepperRecord(Record<Event> dataPrepperRecord) {
            this.dataPrepperRecord = dataPrepperRecord;
            return this;
        }

        public KinesisInputOutputRecordBuilder withIncomingRecordSizeBytes(long incomingRecordSizeBytes) {
            this.incomingRecordSizeBytes = incomingRecordSizeBytes;
            return this;
        }

        public KinesisInputOutputRecord build() {
            return new KinesisInputOutputRecord(this.dataPrepperRecord, this.incomingRecordSizeBytes);
        }

        public String toString() {
            return "KinesisInputOutputRecord.KinesisInputOutputRecordBuilder(dataPrepperRecord=" + String.valueOf(this.dataPrepperRecord) + ", incomingRecordSizeBytes=" + this.incomingRecordSizeBytes + ")";
        }
    }
}

