/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.AwsAuthenticationConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.kinesis.common.KinesisClientUtil;

public class KinesisClientFactory {
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final AwsCredentialsProvider defaultCredentialsProvider;
    private final AwsAuthenticationConfig awsAuthenticationConfig;

    public KinesisClientFactory(AwsCredentialsSupplier awsCredentialsSupplier, AwsAuthenticationConfig awsAuthenticationConfig) {
        this.awsCredentialsProvider = awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().withRegion(awsAuthenticationConfig.getAwsRegion()).withStsRoleArn(awsAuthenticationConfig.getAwsStsRoleArn()).withStsExternalId(awsAuthenticationConfig.getAwsStsExternalId()).withStsHeaderOverrides(awsAuthenticationConfig.getAwsStsHeaderOverrides()).build());
        this.defaultCredentialsProvider = awsCredentialsSupplier.getProvider(AwsCredentialsOptions.defaultOptionsWithDefaultCredentialsProvider());
        this.awsAuthenticationConfig = awsAuthenticationConfig;
    }

    public DynamoDbAsyncClient buildDynamoDBClient(Region region) {
        return (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().credentialsProvider(this.defaultCredentialsProvider)).region(region)).build();
    }

    public KinesisAsyncClient buildKinesisAsyncClient(Region region) {
        return KinesisClientUtil.createKinesisAsyncClient((KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)KinesisAsyncClient.builder().credentialsProvider(this.awsCredentialsProvider)).region(region)));
    }

    public CloudWatchAsyncClient buildCloudWatchAsyncClient(Region region) {
        return (CloudWatchAsyncClient)((CloudWatchAsyncClientBuilder)((CloudWatchAsyncClientBuilder)CloudWatchAsyncClient.builder().credentialsProvider(this.defaultCredentialsProvider)).region(region)).build();
    }
}

