/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaProducerConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaProducerProperties;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.util.AuthenticationPropertyConfigurer;
import org.opensearch.dataprepper.plugins.kafka.util.KafkaSecurityConfigurer;
import org.opensearch.dataprepper.plugins.kafka.util.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkPropertyConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(SinkPropertyConfigurer.class);
    private static final String VALUE_SERIALIZER = "value.serializer";
    private static final String KEY_SERIALIZER = "key.serializer";
    private static final String SESSION_TIMEOUT_MS_CONFIG = "30000";
    private static final String REGISTRY_URL = "schema.registry.url";
    private static final String REGISTRY_BASIC_AUTH_USER_INFO = "schema.registry.basic.auth.user.info";
    private static final String CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    public static final String BUFFER_MEMORY = "buffer.memory";
    public static final String COMPRESSION_TYPE = "compression.type";
    public static final String RETRIES = "retries";
    public static final String BATCH_SIZE = "batch.size";
    public static final String CLIENT_DNS_LOOKUP = "client.dns.lookup";
    public static final String CLIENT_ID = "client.id";
    public static final String CONNECTIONS_MAX_IDLE_MS = "connections.max.idle.ms";
    public static final String DELIVERY_TIMEOUT_MS = "delivery.timeout.ms";
    public static final String LINGER_MS = "linger.ms";
    public static final String MAX_BLOCK_MS = "max.block.ms";
    public static final String MAX_REQUEST_SIZE = "max.request.size";
    public static final String PARTITIONER_CLASS = "partitioner.class";
    public static final String PARTITIONER_IGNORE_KEYS = "partitioner.ignore.keys";
    public static final String RECEIVE_BUFFER_BYTES = "receive.buffer.bytes";
    public static final String REQUEST_TIMEOUT_MS = "request.timeout.ms";
    public static final String SEND_BUFFER_BYTES = "send.buffer.bytes";
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS = "socket.connection.setup.timeout.max.ms";
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MS = "socket.connection.setup.timeout.ms";
    public static final String ACKS = "acks";
    public static final String ENABLE_IDEMPOTENCE = "enable.idempotence";
    public static final String INTERCEPTOR_CLASSES = "interceptor.classes";
    public static final String MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION = "max.in.flight.requests.per.connection";
    public static final String METADATA_MAX_AGE_MS = "metadata.max.age.ms";
    public static final String METADATA_MAX_IDLE_MS = "metadata.max.idle.ms";
    public static final String METRIC_REPORTERS = "metric.reporters";
    public static final String METRICS_NUM_SAMPLES = "metrics.num.samples";
    public static final String METRICS_RECORDING_LEVEL = "metrics.recording.level";
    public static final String METRICS_SAMPLE_WINDOW_MS = "metrics.sample.window.ms";
    public static final String PARTITIONER_ADAPTIVE_PARTITIONING_ENABLE = "partitioner.adaptive.partitioning.enable";
    public static final String PARTITIONER_AVAILABILITY_TIMEOUT_MS = "partitioner.availability.timeout.ms";
    public static final String RECONNECT_BACKOFF_MAX_MS = "reconnect.backoff.max.ms";
    public static final String RECONNECT_BACKOFF_MS = "reconnect.backoff.ms";
    public static final String RETRY_BACKOFF_MS = "retry.backoff.ms";

    public static Properties getProducerProperties(KafkaProducerConfig kafkaProducerConfig) {
        Properties properties = new Properties();
        SinkPropertyConfigurer.setCommonServerProperties(properties, kafkaProducerConfig);
        if (kafkaProducerConfig.getSchemaConfig() != null) {
            SinkPropertyConfigurer.setSchemaProps(kafkaProducerConfig.getSerdeFormat(), kafkaProducerConfig.getSchemaConfig(), properties);
        }
        if (kafkaProducerConfig.getKafkaProducerProperties() != null) {
            SinkPropertyConfigurer.setPropertiesProviderByKafkaProducer(kafkaProducerConfig.getKafkaProducerProperties(), properties);
        }
        SinkPropertyConfigurer.setAuthProperties(kafkaProducerConfig, properties);
        return properties;
    }

    private static void setAuthProperties(KafkaProducerConfig kafkaSinkConfig, Properties properties) {
        if (kafkaSinkConfig.getAuthConfig() == null) {
            return;
        }
        if (kafkaSinkConfig.getAuthConfig().getSaslAuthConfig().getPlainTextAuthConfig() != null) {
            String sslEndpointAlgorithm = kafkaSinkConfig.getAuthConfig().getSaslAuthConfig().getSslEndpointAlgorithm();
            if (null != sslEndpointAlgorithm && !sslEndpointAlgorithm.isEmpty() && sslEndpointAlgorithm.equalsIgnoreCase("https")) {
                AuthenticationPropertyConfigurer.setSaslPlainProperties(kafkaSinkConfig.getAuthConfig().getSaslAuthConfig().getPlainTextAuthConfig(), properties);
            } else {
                AuthenticationPropertyConfigurer.setSaslPlainTextProperties(kafkaSinkConfig.getAuthConfig().getSaslAuthConfig().getPlainTextAuthConfig(), properties);
            }
        } else if (kafkaSinkConfig.getAuthConfig().getSaslAuthConfig().getOAuthConfig() != null) {
            AuthenticationPropertyConfigurer.setOauthProperties(kafkaSinkConfig.getAuthConfig().getSaslAuthConfig().getOAuthConfig(), properties);
        }
    }

    private static void setCommonServerProperties(Properties properties, KafkaProducerConfig kafkaSinkConfig) {
        if (Objects.nonNull(kafkaSinkConfig.getBootstrapServers())) {
            properties.put("bootstrap.servers", String.join((CharSequence)",", kafkaSinkConfig.getBootstrapServers()));
        }
        properties.put("session.timeout.ms", SESSION_TIMEOUT_MS_CONFIG);
    }

    private static void validateForRegistryURL(String serdeFormat, SchemaConfig schemaConfig) {
        if (serdeFormat.equalsIgnoreCase(MessageFormat.AVRO.toString()) && (schemaConfig == null || schemaConfig.getRegistryURL() == null || schemaConfig.getRegistryURL().isBlank() || schemaConfig.getRegistryURL().isEmpty())) {
            throw new RuntimeException("Schema registry is mandatory when serde type is avro");
        }
        if (serdeFormat.equalsIgnoreCase(MessageFormat.PLAINTEXT.toString()) && schemaConfig != null && schemaConfig.getRegistryURL() != null) {
            throw new RuntimeException("Schema registry is not required for type plaintext");
        }
    }

    public static void setSchemaProps(String serdeFormat, SchemaConfig schemaConfig, Properties properties) {
        String registryURL;
        SinkPropertyConfigurer.validateForRegistryURL(serdeFormat, schemaConfig);
        String string = registryURL = schemaConfig != null ? schemaConfig.getRegistryURL() : null;
        if (registryURL != null && !registryURL.isEmpty()) {
            properties.put(REGISTRY_URL, registryURL);
        }
        SinkPropertyConfigurer.setSchemaCredentialsConfig(schemaConfig, properties);
    }

    public static void setSchemaCredentialsConfig(SchemaConfig schemaConfig, Properties properties) {
        if (!ObjectUtils.isEmpty((Object)schemaConfig.getBasicAuthCredentialsSource())) {
            properties.put(CREDENTIALS_SOURCE, schemaConfig.getBasicAuthCredentialsSource());
        }
        if (!ObjectUtils.isEmpty((Object)schemaConfig.getSchemaRegistryApiKey()) && !ObjectUtils.isEmpty((Object)schemaConfig.getSchemaRegistryApiSecret())) {
            String apiKey = schemaConfig.getSchemaRegistryApiKey();
            String apiSecret = schemaConfig.getSchemaRegistryApiSecret();
            properties.put(REGISTRY_BASIC_AUTH_USER_INFO, apiKey + ":" + apiSecret);
        }
    }

    private static void setPropertiesProviderByKafkaProducer(KafkaProducerProperties producerProperties, Properties properties) {
        List metricReporters;
        List interceptorClasses;
        if (producerProperties.getBufferMemory() != null) {
            properties.put(BUFFER_MEMORY, (Object)ByteCount.parse((String)producerProperties.getBufferMemory()).getBytes());
        }
        if (producerProperties.getCompressionType() != null) {
            properties.put(COMPRESSION_TYPE, producerProperties.getCompressionType());
        }
        properties.put(RETRIES, (Object)producerProperties.getRetries());
        if (producerProperties.getBatchSize() > 0) {
            properties.put(BATCH_SIZE, (Object)producerProperties.getBatchSize());
        }
        if (producerProperties.getClientDnsLookup() != null) {
            properties.put(CLIENT_DNS_LOOKUP, producerProperties.getClientDnsLookup());
        }
        if (producerProperties.getClientId() != null) {
            properties.put(CLIENT_ID, producerProperties.getClientId());
        }
        if (producerProperties.getConnectionsMaxIdleMs() > 0L) {
            properties.put(CONNECTIONS_MAX_IDLE_MS, producerProperties.getConnectionsMaxIdleMs());
        }
        if (producerProperties.getDeliveryTimeoutMs() > 0L) {
            properties.put(DELIVERY_TIMEOUT_MS, (Object)producerProperties.getDeliveryTimeoutMs().intValue());
        }
        if (producerProperties.getLingerMs() > 0L) {
            properties.put(LINGER_MS, producerProperties.getLingerMs());
        }
        if (producerProperties.getMaxBlockMs() > 0L) {
            properties.put(MAX_BLOCK_MS, producerProperties.getMaxBlockMs());
        }
        if (producerProperties.getMaxRequestSize() > 0) {
            properties.put(MAX_REQUEST_SIZE, (Object)producerProperties.getMaxRequestSize());
        }
        if (producerProperties.getPartitionerClass() != null) {
            properties.put(PARTITIONER_CLASS, producerProperties.getPartitionerClass().getName());
        }
        if (producerProperties.getPartitionerIgnoreKeys() != null) {
            properties.put(PARTITIONER_IGNORE_KEYS, producerProperties.getPartitionerIgnoreKeys());
        }
        if (producerProperties.getReceiveBufferBytes() != null) {
            Long receiveBufferBytes = ByteCount.parse((String)producerProperties.getReceiveBufferBytes()).getBytes();
            properties.put(RECEIVE_BUFFER_BYTES, (Object)receiveBufferBytes.intValue());
        }
        if (producerProperties.getRequestTimeoutMs() > 0L) {
            properties.put(REQUEST_TIMEOUT_MS, (Object)producerProperties.getRequestTimeoutMs().intValue());
        }
        if (producerProperties.getSendBufferBytes() != null) {
            Long sendBufferBytes = ByteCount.parse((String)producerProperties.getSendBufferBytes()).getBytes();
            properties.put(SEND_BUFFER_BYTES, (Object)sendBufferBytes.intValue());
        }
        if (producerProperties.getSocketConnectionSetupMaxTimeout() > 0L) {
            properties.put(SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS, producerProperties.getSocketConnectionSetupMaxTimeout());
        }
        if (producerProperties.getSocketConnectionSetupTimeout() > 0L) {
            properties.put(SOCKET_CONNECTION_SETUP_TIMEOUT_MS, producerProperties.getSocketConnectionSetupTimeout());
        }
        if (producerProperties.getAcks() != null) {
            properties.put(ACKS, producerProperties.getAcks());
        }
        if (producerProperties.getEnableIdempotence() != null) {
            properties.put(ENABLE_IDEMPOTENCE, producerProperties.getEnableIdempotence());
        }
        if ((interceptorClasses = producerProperties.getInterceptorClasses()) != null && !interceptorClasses.isEmpty()) {
            properties.put(INTERCEPTOR_CLASSES, String.join((CharSequence)",", interceptorClasses));
        }
        if (producerProperties.getMaxInFlightRequestsPerConnection() > 0) {
            properties.put(MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION, (Object)producerProperties.getMaxInFlightRequestsPerConnection());
        }
        if (producerProperties.getMetadataMaxAgeMs() > 0L) {
            properties.put(METADATA_MAX_AGE_MS, producerProperties.getMetadataMaxAgeMs());
        }
        if (producerProperties.getMetadataMaxIdleMs() > 0L) {
            properties.put(METADATA_MAX_IDLE_MS, producerProperties.getMetadataMaxIdleMs());
        }
        if ((metricReporters = producerProperties.getMetricReporters()) != null && !metricReporters.isEmpty()) {
            properties.put(METRIC_REPORTERS, String.join((CharSequence)",", metricReporters));
        }
        if (producerProperties.getMetricsNumSamples() > 0) {
            properties.put(METRICS_NUM_SAMPLES, (Object)producerProperties.getMetricsNumSamples());
        }
        if (producerProperties.getMetricsRecordingLevel() != null) {
            properties.put(METRICS_RECORDING_LEVEL, producerProperties.getMetricsRecordingLevel());
        }
        if (producerProperties.getMetricsSampleWindowMs() > 0L) {
            properties.put(METRICS_SAMPLE_WINDOW_MS, producerProperties.getMetricsSampleWindowMs());
        }
        properties.put(PARTITIONER_ADAPTIVE_PARTITIONING_ENABLE, (Object)producerProperties.isPartitionerAdaptivePartitioningEnable());
        if (producerProperties.getPartitionerAvailabilityTimeoutMs() > 0L) {
            properties.put(PARTITIONER_AVAILABILITY_TIMEOUT_MS, producerProperties.getPartitionerAvailabilityTimeoutMs());
        }
        if (producerProperties.getReconnectBackoffMaxMs() > 0L) {
            properties.put(RECONNECT_BACKOFF_MAX_MS, producerProperties.getReconnectBackoffMaxMs());
        }
        if (producerProperties.getReconnectBackoffMs() > 0L) {
            properties.put(RECONNECT_BACKOFF_MS, producerProperties.getReconnectBackoffMs());
        }
        if (producerProperties.getRetryBackoffMs() > 0L) {
            properties.put(RETRY_BACKOFF_MS, producerProperties.getRetryBackoffMs());
        }
        LOG.info("Producer properties");
        properties.entrySet().forEach(prop -> LOG.info("property " + String.valueOf(prop.getKey()) + " value" + String.valueOf(prop.getValue())));
        LOG.info("Producer properties ends");
    }

    public static Properties getPropertiesForAdminClient(KafkaProducerConfig kafkaProducerConfig) {
        Properties properties = new Properties();
        SinkPropertyConfigurer.setCommonServerProperties(properties, kafkaProducerConfig);
        KafkaSecurityConfigurer.setAuthProperties(properties, kafkaProducerConfig, LOG);
        properties.put("retention.ms", kafkaProducerConfig.getTopic().getRetentionPeriod());
        return properties;
    }
}

