/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.opensearch.dataprepper.plugins.truststore.TrustStoreProvider;

public class CustomClientSslEngineFactory
implements SslEngineFactory {
    String certificateContent = null;

    public void configure(Map<String, ?> configs) {
        this.certificateContent = configs.get("certificateContent").toString();
    }

    private TrustManager[] getTrustManager() {
        TrustManager[] trustManagers = Objects.nonNull(this.certificateContent) ? TrustStoreProvider.createTrustManager((String)this.certificateContent) : TrustStoreProvider.createTrustAllManager();
        return trustManagers;
    }

    public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, this.getTrustManager(), new SecureRandom());
            SSLEngine sslEngine = sslContext.createSSLEngine(peerHost, peerPort);
            sslEngine.setUseClientMode(true);
            return sslEngine;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        return null;
    }

    public boolean shouldBeRebuilt(Map<String, Object> nextConfigs) {
        return false;
    }

    public Set<String> reconfigurableConfigs() {
        return null;
    }

    public KeyStore keystore() {
        return null;
    }

    public KeyStore truststore() {
        return null;
    }

    public void close() {
    }
}

