/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.consumer;

import org.opensearch.dataprepper.model.breaker.CircuitBreaker;

@FunctionalInterface
public interface PauseConsumePredicate {
    public boolean pauseConsuming();

    public static PauseConsumePredicate circuitBreakingPredicate(final CircuitBreaker circuitBreaker) {
        if (circuitBreaker == null) {
            return PauseConsumePredicate.noPause();
        }
        return new PauseConsumePredicate(){

            @Override
            public boolean pauseConsuming() {
                return circuitBreaker.isOpen();
            }

            public String toString() {
                return "Circuit Breaker";
            }
        };
    }

    public static PauseConsumePredicate noPause() {
        return () -> false;
    }
}

