/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.buffer.serialization;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serializer;
import org.opensearch.dataprepper.plugins.kafka.buffer.KafkaBufferMessage;
import org.opensearch.dataprepper.plugins.kafka.common.KafkaDataConfig;

class BufferMessageSerializer<T>
implements Serializer<T> {
    private final Serializer<T> dataSerializer;
    private final KafkaDataConfig dataConfig;

    public BufferMessageSerializer(Serializer<T> dataSerializer, KafkaDataConfig dataConfig) {
        this.dataSerializer = Objects.requireNonNull(dataSerializer);
        this.dataConfig = Objects.requireNonNull(dataConfig);
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        byte[] serializedData = this.dataSerializer.serialize(topic, data);
        KafkaBufferMessage.BufferData bufferedData = this.buildProtobufMessage(serializedData);
        return bufferedData.toByteArray();
    }

    Serializer<T> getDataSerializer() {
        return this.dataSerializer;
    }

    private KafkaBufferMessage.BufferData buildProtobufMessage(byte[] serializedData) {
        KafkaBufferMessage.BufferData.Builder messageBuilder = KafkaBufferMessage.BufferData.newBuilder().setData(ByteString.copyFrom((byte[])serializedData)).setMessageFormat(KafkaBufferMessage.MessageFormat.MESSAGE_FORMAT_BYTES);
        if (this.dataConfig.getEncryptionKeySupplier() != null) {
            messageBuilder = messageBuilder.setEncrypted(true);
            if (this.dataConfig.getEncryptedDataKey() != null) {
                messageBuilder = messageBuilder.setEncryptedDataKey(ByteString.copyFromUtf8((String)this.dataConfig.getEncryptedDataKey()));
            }
        }
        return messageBuilder.build();
    }
}

