/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

public class KafkaProducerProperties {
    static final String DEFAULT_BYTE_CAPACITY = "50mb";
    static final Duration DEFAULT_DELIVERY_TIMEOUT_MS = Duration.ofMillis(120000L);
    static final Long DEFAULT_LINGER_MS = 0L;
    static final Duration DEFAULT_MAX_BLOCK_MS = Duration.ofMillis(60000L);
    static final Duration DEFAULT_CONNECTION_MAX_IDLE_MS = Duration.ofMillis(540000L);
    static final Duration DEFAULT_REQUEST_TIMEOUT_MS = Duration.ofMillis(30000L);
    static final Duration DEFAULT_SOCKET_CONNECTION_SETUP_MAX_TIMEOUT = Duration.ofMillis(30000L);
    static final Duration DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT = Duration.ofMillis(10000L);
    static final Duration DEFAULT_METADATA_MAX_AGE_MS = Duration.ofMillis(300000L);
    static final Duration DEFAULT_METADATA_MAX_IDLE_MS = Duration.ofMillis(300000L);
    static final Duration DEFAULT_METRICS_SAMPLE_WINDOW_MS = Duration.ofMillis(300000L);
    static final Duration DEFAULT_PARTITIONER_AVAILABILITY_TIMEOUT_MS = Duration.ofMillis(0L);
    static final Duration DEFAULT_RECONNECT_BACKOFF_MAX_MS = Duration.ofMillis(1000L);
    static final Duration DEFAULT_RECONNECT_BACKOFF_MS = Duration.ofMillis(50L);
    static final Duration DEFAULT_RETRY_BACKOFF_MS = Duration.ofMillis(100L);
    public static final int DEFAULT_MAX_REQUEST_SIZE = 0x100000;
    @JsonProperty(value="buffer_memory")
    private String bufferMemory = "50mb";
    @JsonProperty(value="compression_type")
    private String compressionType;
    @JsonProperty(value="retries")
    private int retries;
    @JsonProperty(value="batch_size")
    private int batchSize;
    @JsonProperty(value="client_dns_lookup")
    private String clientDnsLookup;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="connections_max_idle")
    private Duration connectionsMaxIdleMs = DEFAULT_CONNECTION_MAX_IDLE_MS;
    @JsonProperty(value="delivery_timeout")
    private Duration deliveryTimeoutMs = DEFAULT_DELIVERY_TIMEOUT_MS;
    @JsonProperty(value="linger_ms")
    private Long lingerMs = DEFAULT_LINGER_MS;
    @JsonProperty(value="max_block")
    private Duration maxBlockMs = DEFAULT_MAX_BLOCK_MS;
    @JsonProperty(value="max_request_size")
    private int maxRequestSize = 0x100000;
    @JsonProperty(value="partitioner_class")
    private Class partitionerClass;
    @JsonProperty(value="partitioner_ignore_keys")
    private Boolean partitionerIgnoreKeys;
    @JsonProperty(value="receive_buffer")
    private String receiveBufferBytes = "50mb";
    @JsonProperty(value="request_timeout")
    private Duration requestTimeoutMs = DEFAULT_REQUEST_TIMEOUT_MS;
    @JsonProperty(value="send_buffer")
    private String sendBufferBytes = "50mb";
    @JsonProperty(value="socket_connection_setup_timeout_max")
    private Duration socketConnectionSetupMaxTimeout = DEFAULT_SOCKET_CONNECTION_SETUP_MAX_TIMEOUT;
    @JsonProperty(value="socket_connection_setup_timeout")
    private Duration socketConnectionSetupTimeout = DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT;
    @JsonProperty(value="acks")
    private String acks;
    @JsonProperty(value="enable_idempotence")
    private Boolean enableIdempotence;
    @JsonProperty(value="interceptor_classes")
    private List interceptorClasses;
    @JsonProperty(value="max_in_flight_requests_per_connection")
    private int maxInFlightRequestsPerConnection;
    @JsonProperty(value="metadata_max_age")
    private Duration metadataMaxAgeMs = DEFAULT_METADATA_MAX_AGE_MS;
    @JsonProperty(value="metadata_max_idle")
    private Duration metadataMaxIdleMs = DEFAULT_METADATA_MAX_IDLE_MS;
    @JsonProperty(value="metric_reporters")
    private List metricReporters;
    @JsonProperty(value="metrics_num_samples")
    private int metricsNumSamples;
    @JsonProperty(value="metrics_recording_level")
    private String metricsRecordingLevel;
    @JsonProperty(value="metrics_sample_window")
    private Duration metricsSampleWindowMs = DEFAULT_METRICS_SAMPLE_WINDOW_MS;
    @JsonProperty(value="partitioner_adaptive_partitioning_enable")
    private boolean partitionerAdaptivePartitioningEnable;
    @JsonProperty(value="partitioner_availability_timeout")
    private Duration partitionerAvailabilityTimeoutMs = DEFAULT_PARTITIONER_AVAILABILITY_TIMEOUT_MS;
    @JsonProperty(value="reconnect_backoff_max")
    private Duration reconnectBackoffMaxMs = DEFAULT_RECONNECT_BACKOFF_MAX_MS;
    @JsonProperty(value="reconnect_backoff")
    private Duration reconnectBackoffMs = DEFAULT_RECONNECT_BACKOFF_MS;
    @JsonProperty(value="retry_backoff")
    private Duration retryBackoffMs = DEFAULT_RETRY_BACKOFF_MS;

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public int getRetries() {
        if (this.retries == 0) {
            this.retries = 5;
        }
        return this.retries;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getClientDnsLookup() {
        return this.clientDnsLookup;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Long getLingerMs() {
        return this.lingerMs;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public Class getPartitionerClass() {
        return this.partitionerClass;
    }

    public Boolean getPartitionerIgnoreKeys() {
        return this.partitionerIgnoreKeys;
    }

    public String getAcks() {
        return this.acks;
    }

    public Boolean getEnableIdempotence() {
        return this.enableIdempotence;
    }

    public List getInterceptorClasses() {
        return this.interceptorClasses;
    }

    public int getMaxInFlightRequestsPerConnection() {
        return this.maxInFlightRequestsPerConnection;
    }

    public List getMetricReporters() {
        return this.metricReporters;
    }

    public int getMetricsNumSamples() {
        return this.metricsNumSamples;
    }

    public String getMetricsRecordingLevel() {
        return this.metricsRecordingLevel;
    }

    public boolean isPartitionerAdaptivePartitioningEnable() {
        return this.partitionerAdaptivePartitioningEnable;
    }

    public String getBufferMemory() {
        return this.bufferMemory;
    }

    public Long getConnectionsMaxIdleMs() {
        return this.connectionsMaxIdleMs.toMillis();
    }

    public Long getDeliveryTimeoutMs() {
        return this.deliveryTimeoutMs.toMillis();
    }

    public Long getMaxBlockMs() {
        return this.maxBlockMs.toMillis();
    }

    public String getReceiveBufferBytes() {
        return this.receiveBufferBytes;
    }

    public Long getRequestTimeoutMs() {
        return this.requestTimeoutMs.toMillis();
    }

    public String getSendBufferBytes() {
        return this.sendBufferBytes;
    }

    public Long getSocketConnectionSetupMaxTimeout() {
        return this.socketConnectionSetupMaxTimeout.toMillis();
    }

    public Long getSocketConnectionSetupTimeout() {
        return this.socketConnectionSetupTimeout.toMillis();
    }

    public Long getMetadataMaxAgeMs() {
        return this.metadataMaxAgeMs.toMillis();
    }

    public Long getMetadataMaxIdleMs() {
        return this.metadataMaxIdleMs.toMillis();
    }

    public Long getMetricsSampleWindowMs() {
        return this.metricsSampleWindowMs.toMillis();
    }

    public Long getPartitionerAvailabilityTimeoutMs() {
        return this.partitionerAvailabilityTimeoutMs.toMillis();
    }

    public Long getReconnectBackoffMaxMs() {
        return this.reconnectBackoffMaxMs.toMillis();
    }

    public Long getReconnectBackoffMs() {
        return this.reconnectBackoffMs.toMillis();
    }

    public Long getRetryBackoffMs() {
        return this.retryBackoffMs.toMillis();
    }
}

