/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import java.nio.file.Paths;
import org.opensearch.dataprepper.plugins.certificate.validation.PemObjectValidator;
import org.opensearch.dataprepper.plugins.kafka.configuration.EncryptionType;

public class EncryptionConfig {
    @JsonProperty(value="type")
    private EncryptionType type = EncryptionType.SSL;
    @JsonAlias(value={"certificate_content"})
    @JsonProperty(value="certificate")
    private String certificate;
    @JsonProperty(value="trust_store_file_path")
    private String trustStoreFilePath;
    @JsonProperty(value="trust_store_password")
    private String trustStorePassword;
    @JsonProperty(value="insecure")
    private boolean insecure = false;

    public EncryptionType getType() {
        return this.type;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getTrustStoreFilePath() {
        return this.trustStoreFilePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean getInsecure() {
        return this.insecure;
    }

    @AssertTrue(message="certificate must be either valid PEM file path or public key content.")
    @AssertTrue(message="certificate must be either valid PEM file path or public key content.") boolean isCertificateValid() {
        if (PemObjectValidator.isPemObject((String)this.certificate)) {
            return true;
        }
        try {
            Paths.get(this.certificate, new String[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

