/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import java.util.stream.Stream;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsIamAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.OAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.PlainTextAuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.ScramAuthConfig;

public class AuthConfig {
    @Valid
    @JsonProperty(value="sasl")
    private SaslAuthConfig saslAuthConfig;

    public SaslAuthConfig getSaslAuthConfig() {
        return this.saslAuthConfig;
    }

    public static class SaslAuthConfig {
        @JsonAlias(value={"plain"})
        @JsonProperty(value="plaintext")
        private PlainTextAuthConfig plainTextAuthConfig;
        @JsonProperty(value="scram")
        private ScramAuthConfig scramAuthConfig;
        @JsonProperty(value="oauth")
        private OAuthConfig oAuthConfig;
        @JsonProperty(value="aws_msk_iam")
        private AwsIamAuthConfig awsIamAuthConfig;
        @JsonProperty(value="ssl_endpoint_identification_algorithm")
        private String sslEndpointAlgorithm;

        public AwsIamAuthConfig getAwsIamAuthConfig() {
            return this.awsIamAuthConfig;
        }

        public PlainTextAuthConfig getPlainTextAuthConfig() {
            return this.plainTextAuthConfig;
        }

        public ScramAuthConfig getScramAuthConfig() {
            return this.scramAuthConfig;
        }

        public OAuthConfig getOAuthConfig() {
            return this.oAuthConfig;
        }

        public String getSslEndpointAlgorithm() {
            return this.sslEndpointAlgorithm;
        }

        @AssertTrue(message="Only one of AwsIam or oAuth or SCRAM or PlainText auth config must be specified")
        public @AssertTrue(message="Only one of AwsIam or oAuth or SCRAM or PlainText auth config must be specified") boolean hasOnlyOneConfig() {
            return Stream.of(new Object[]{this.awsIamAuthConfig, this.plainTextAuthConfig, this.oAuthConfig, this.scramAuthConfig}).filter(n -> n != null).count() == 1L;
        }
    }
}

