/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common.aws;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsCredentialsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaConnectionConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class AwsContext {
    private final AwsConfig awsConfig;
    private final AwsCredentialsSupplier awsCredentialsSupplier;

    public AwsContext(KafkaConnectionConfig connectionConfig, AwsCredentialsSupplier awsCredentialsSupplier) {
        this.awsConfig = connectionConfig.getAwsConfig();
        this.awsCredentialsSupplier = awsCredentialsSupplier;
    }

    public AwsCredentialsProvider getOrDefault(AwsCredentialsConfig awsCredentialsConfig) {
        if (awsCredentialsConfig == null || awsCredentialsConfig.getStsRoleArn() == null) {
            return this.getDefault();
        }
        return this.getFromOptions(awsCredentialsConfig.toCredentialsOptions());
    }

    public Region getRegionOrDefault(AwsCredentialsConfig awsCredentialsConfig) {
        if (awsCredentialsConfig != null && awsCredentialsConfig.getRegion() != null) {
            return Region.of((String)awsCredentialsConfig.getRegion());
        }
        if (this.awsConfig != null && this.awsConfig.getRegion() != null) {
            return Region.of((String)this.awsConfig.getRegion());
        }
        return null;
    }

    private AwsCredentialsProvider getDefault() {
        AwsCredentialsOptions credentialsOptions = this.awsConfig != null ? this.awsConfig.toCredentialsOptions() : AwsCredentialsOptions.defaultOptions();
        return this.getFromOptions(credentialsOptions);
    }

    private AwsCredentialsProvider getFromOptions(AwsCredentialsOptions awsCredentialsOptions) {
        return this.awsCredentialsSupplier.getProvider(awsCredentialsOptions);
    }
}

