/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.buffer.serialization;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.kafka.common.serialization.Deserializer;
import org.opensearch.dataprepper.plugins.kafka.buffer.KafkaBufferMessage;

class BufferMessageDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> dataDeserializer;

    public BufferMessageDeserializer(Deserializer<T> dataDeserializer) {
        this.dataDeserializer = dataDeserializer;
    }

    public T deserialize(String topic, byte[] data) {
        KafkaBufferMessage.BufferData bufferedData;
        try {
            bufferedData = KafkaBufferMessage.BufferData.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        byte[] dataBytes = bufferedData.getData().toByteArray();
        return (T)this.dataDeserializer.deserialize(topic, dataBytes);
    }

    Deserializer<T> getDataDeserializer() {
        return this.dataDeserializer;
    }
}

