/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira;

import java.time.Instant;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.source.atlassian.AtlassianSourceConfig;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianAuthConfig;
import org.opensearch.dataprepper.plugins.source.jira.JiraSourceConfig;
import org.opensearch.dataprepper.plugins.source.jira.utils.JiraConfigHelper;
import org.opensearch.dataprepper.plugins.source.source_crawler.CrawlerApplicationContextMarker;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.Crawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourceConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourcePlugin;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.LeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.PaginationCrawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.PluginExecutorServiceProvider;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.PaginationCrawlerLeaderProgressState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="jira", pluginType=Source.class, pluginConfigurationType=JiraSourceConfig.class, packagesToScan={CrawlerApplicationContextMarker.class, AtlassianSourceConfig.class, JiraSource.class})
public class JiraSource
extends CrawlerSourcePlugin {
    private static final Logger log = LoggerFactory.getLogger(JiraSource.class);
    private final JiraSourceConfig jiraSourceConfig;
    private final AtlassianAuthConfig jiraOauthConfig;

    @DataPrepperPluginConstructor
    public JiraSource(PluginMetrics pluginMetrics, JiraSourceConfig jiraSourceConfig, AtlassianAuthConfig jiraOauthConfig, PluginFactory pluginFactory, AcknowledgementSetManager acknowledgementSetManager, PaginationCrawler crawler, PluginExecutorServiceProvider executorServiceProvider) {
        super("jira", pluginMetrics, (CrawlerSourceConfig)jiraSourceConfig, pluginFactory, acknowledgementSetManager, (Crawler)crawler, executorServiceProvider);
        log.info("Creating Jira Source Plugin");
        this.jiraSourceConfig = jiraSourceConfig;
        this.jiraOauthConfig = jiraOauthConfig;
    }

    public void start(Buffer<Record<Event>> buffer) {
        log.info("Starting Jira Source Plugin... ");
        JiraConfigHelper.validateConfig(this.jiraSourceConfig);
        this.jiraOauthConfig.initCredentials();
        super.start(buffer);
    }

    protected LeaderProgressState createLeaderProgressState() {
        return new PaginationCrawlerLeaderProgressState(Instant.EPOCH);
    }

    public void stop() {
        log.info("Stopping Jira Source Plugin");
        super.stop();
    }
}

